package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.order.TakeawayOrder;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.joe.print.mvp.model.bean.PrintBillBean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 外送接單，印單   已改新版
 */
public class PrintOtherOrder extends PrinterRoot {


    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        OrderDetails.DataBean dataBean = TakeawayOrder.getInstance().getShoppingCart().getDataBean();
        if (dataBean != null) {
            Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
            //廚房單，可能會有多個IP打印
            //獲得ip打印列表，
            //再將食品數據根據打印位置分組。
            //打印一組之後，關閉連接，切換第二台打印機ip，如此循環
            //打印完成之後，返回所有打印結果。
            //如果需要打印印單，加上
            List<Bitmap> bitmaps = new ArrayList<>();
//            Bitmap bitmap = initPrintView(mContext, dataBean);
            Bitmap bitmap = getBitmap(mContext, dataBean, deviceBean);
//            for (int i = 0; i < getPrintCount(mContext); i++) {
            bitmaps.add(bitmap);
//            }
            merge2ResultMap(bitmapMaps, "", bitmaps);
            return bitmapMaps;
        }
        return null;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.DeliveryPrintCount,1);
    }

    private Bitmap getBitmap(Context mContext, OrderDetails.DataBean data, PrinterDeviceBean deviceBean) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        //頭部
        layout.addView(getHeader(mContext));
        //訂單信息
        layout.addView(getTakeawayOrderInfo(mContext, data));
        //食品
        layout.addView(getTextLine(mContext, "項目"));
        layout.addView(getDiningFoodList(mContext, OrderDetail.productMameBeanToOrderDetail(0, data.getPRODUCT_NAME()), deviceBean, 1, true));
        layout.addView(getLine(mContext));
        //訂單金額信息
        List<PrintBillBean> billData = new ArrayList<>();
        billData.add(getBillBean("合計：", MONETARY_UNIT + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE())));
        if (data.getLunchbox() != 0) {
            billData.add(getBillBean("餐盒費：", MONETARY_UNIT + data.getLunchbox()));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            billData.add(getBillBean("送貨費：", MONETARY_UNIT + data.getDELIVERY_CHARGE()));
        }
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                billData.add(getBillBean(coupon.getCouponName() + "：", "-" + MONETARY_UNIT + coupon.getDiscount_amount()));
            }
        }
        layout.addView(getTakeawayBillInfoView(mContext, billData));
        layout.addView(getLine(mContext));
        //總金額34sp
        layout.addView(getTakeawayLargeAmount(mContext, "總金額：", MONETARY_UNIT + data.getTOTAL_AMOUNT()));
        layout.addView(getLine(mContext));
        //支付信息
        addTakeawayPayViews(mContext, layout, data.getPayMultiple(), MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()));
        //用戶信息
        getTakeawayReceiver(mContext, data, layout);
        //尾部
        return viewToZoomBitmap(mContext, layout, deviceBean);
    }

    private PrintBillBean getBillBean(String title, String value) {
        return new PrintBillBean(title, value);
    }

}
