package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.FunctionListModule;
import com.gingersoft.supply_chain.mvp.contract.FunctionListContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.FunctionListFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 16:15
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = FunctionListModule.class, dependencies = AppComponent.class)
public interface FunctionListComponent {
    void inject(FunctionListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        FunctionListComponent.Builder view(FunctionListContract.View view);

        FunctionListComponent.Builder appComponent(AppComponent appComponent);

        FunctionListComponent build();
    }
}