package com.gingersoft.gsa.cloud.table.mvp.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import android.widget.Button;
import android.widget.Chronometer;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableManage;
import com.gingersoft.gsa.cloud.base.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerOrderContentComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.OrderContentContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.OrderContentPresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.ChooseNumberDialog;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

import org.simple.eventbus.EventBus;

import java.util.Date;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description: 賬單內容
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class OrderContentActivity extends BaseActivity<OrderContentPresenter> implements OrderContentContract.View {

    @BindView(R2.id.ctime)
    Chronometer chronometer;

    @BindView(R2.id.btn_table)
    QMUIAlphaButton btn_table;

    @BindView(R2.id.tv_server_main)
    TextView tv_server_main;
    @BindView(R2.id.tv_time)
    TextView tv_time;
    @BindView(R2.id.btn_people_num)
    QMUIAlphaButton btn_people_num;
    @BindView(R2.id.rv_top_function)
    RecyclerView rv_top_function;
    @BindView(R2.id.rv_food)
    RecyclerView rv_food;


    @BindView(R2.id.btn_order_count)
    Button btn_order_count;
    @BindView(R2.id.tv_whole)
    TextView tv_whole;
    @BindView(R2.id.tv_total)
    TextView tv_total;

    private ChooseNumberDialog chooseNumberDialog;

    public static final int BILL_CODE = 1002;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerOrderContentComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.table_activity_order_content; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        QMUIDisplayHelper.cancelFullScreen(this);

        initOrderDetail();
        initTopInfo();
        mPresenter.initTopFunctionData();
        mPresenter.initAdapter();
        mPresenter.initOrderTopFunctionListener();
    }

    public void initOrderDetail() {

        int foodCount = mPresenter.getFoodCount();
        if (foodCount > 0) {
            btn_order_count.setText(String.valueOf(foodCount));
            btn_order_count.setVisibility(View.VISIBLE);
        } else {
            btn_order_count.setVisibility(View.INVISIBLE);
        }

        double total = mPresenter.getTotalMoney();
        tv_whole.setText("合計 $" + total);
        tv_total.setText("$" + total);
    }

    private void initTopInfo() {

        Date dd = MyOrderManage.getInstance().getOpenTableTime();
        String openTime = String.format("%tH:%tM", dd, dd);

        String tableno = "";
        if (!OpenTableManage.getDefault().isSplite() && OpenTableManage.getDefault().getTableBean() != null) {
            tableno = OpenTableManage.getDefault().getTableBean().getTableName();
        } else {//TODO 暫未分檯功能
//            tableno = GSAApplication.tableContract.getTableno().trim() + "-" + GSAApplication.tableContract.getTableno_split().trim();
        }
        btn_table.setText(tableno);

        tv_time.setText("時間:" + openTime);
        btn_people_num.setText(OpenTableManage.getDefault().getPeopleNumber() + "");
        tv_server_main.setText(GsaCloudApplication.getMemberName(this));
    }

    @OnClick({R2.id.btn_table, R2.id.btn_people_num})
    public void onClick(View v) {

        recordOperat(true);

        int id = v.getId();
        if (id == R.id.btn_table) {
            killMyself();
        } else if (id == R.id.btn_people_num) {
            showChoosePeopleNumDialog(true);
        }
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showChoosePeopleNumDialog(boolean isNeedCancel) {
        if (chooseNumberDialog == null) {
            chooseNumberDialog = new ChooseNumberDialog(this);
            chooseNumberDialog.builder();
            chooseNumberDialog.setValueHint("請輸入人數");
//            mInputNumberDialog2.setTitle(LanguageUtils.get_language_system(this, "Meal.Mannumber", "Number"));
//            mInputNumberDialog2.setHeadLayoutVisibility(View.VISIBLE);
            if (!isNeedCancel)
                chooseNumberDialog.setOnBackClickListener(new ChooseNumberDialog.OnBackClickListener() {

                    @Override
                    public void OnBackClick() {
                        recordOperat(true);
                    }
                });
            int backPageBtnVisibility;
            if (isNeedCancel) {
                backPageBtnVisibility = View.GONE;
            } else {
                backPageBtnVisibility = View.VISIBLE;
            }
//            mInputNumberDialog2.setBackPageBtnVisibility(backPageBtnVisibility);
            chooseNumberDialog.setOnClickListener(new ChooseNumberDialog.OnClickListener() {

                @Override
                public void onComfirmClick(String number) {
                    recordOperat(true);
                    //选择的人数大于0
//                    if (Integer.parseInt(number) > 0) {
//                    }
                    mPresenter.updateOrderPerson(number, btn_people_num);
                }

                @Override
                public void onBackPage() {
                    killMyself();
                }
            });
            chooseNumberDialog.setCancelable(isNeedCancel);
        }
        chooseNumberDialog.show();
    }

    @Override
    public void recordOperat(boolean isPressButtonSound) {
        if (isPressButtonSound)
            VibratorUtils.pressButtonSound(this);
        //关闭倒计时
        if (chronometer != null) {
            chronometer.stop();
        }
        //重新开启倒计时
        if (chronometer != null) {
            chronometer.setBase(SystemClock.elapsedRealtime());
            chronometer.start();
        }
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(OrderContentActivity.this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void setTopFunctionAdapter(DefaultAdapter adapter) {
        rv_top_function.setAdapter(adapter);
        setTopFunctionRecycleLayoutManager();
    }

    @Override
    public void setFoodAdapter(DefaultAdapter adapter) {
        rv_food.setAdapter(adapter);
    }

    @Override
    public void setOrderDetailAdapter(DefaultAdapter adapter) {

    }

    @Override
    public void setTopFunctionRecycleLayoutManager() {
        GridLayoutManager funtionRecycleLayoutManager = new GridLayoutManager(this, 3, GridLayoutManager.VERTICAL, false);
        rv_top_function.setLayoutManager(funtionRecycleLayoutManager);
        rv_top_function.setItemAnimator(new DefaultItemAnimator());
    }

    @Override
    public void setFoodRecycleLayoutManager(int orientation) {

    }

    @Override
    public void setTopFunctionRecycleSpanCount(int size) {

    }

    @Override
    public void setFoodRecycleSpanCount(int size) {

    }

    @Override
    public void setTvWhole(double whole) {
        tv_whole.setText("合計 $" + whole);
    }

    @Override
    public void setTvTotal(double total) {
        tv_total.setText("$" + total);
    }

    @Override
    public void printSuccess() {
        // 设置返回码和返回携带的数据
        if (OpenTableManage.getDefault() != null) {
            //通知更新餐台状态
            EventBus.getDefault().post(OpenTableManage.getDefault().getTableBean().getId(), "initTable_status_event");
        }
        setResult(Activity.RESULT_OK, null);
        killMyself();
    }

    @Override
    public void sendSuccess() {
        if (OpenTableManage.getDefault() != null) {
            //通知更新餐台状态
            EventBus.getDefault().post(OpenTableManage.getDefault().getTableBean().getId(), "initTable_status_event");
        }
        setResult(Activity.RESULT_OK, null);
        killMyself();
    }

    @Override
    public void startActivityForResult(int Code, Class clazz, Intent intent) {
        if (intent == null) {
            intent = new Intent(mContext, clazz);
        }
        startActivityForResult(intent, Code);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == BILL_CODE) {
            if (resultCode == Activity.RESULT_OK) {
                setResult(Activity.RESULT_OK, null);
                killMyself();
            }
        }
    }
}
