package com.gingersoft.gsa.cloud.base.common.bean;

import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.database.bean.Combo;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：訂單實體類
 */
public class OrderDetail {
    /**
     * 是否选择
     * 0 未选中
     * 1 被选中但不是主体
     * 2 作为主体被选中
     * 3 由三级菜单进入选中全部
     */
    private int selected = 0;
    //食品名
    private String name;
    //選中數量
    private int number = 0;
    //總價格(已經x數量)
    private double amount_price = 0;
    //單價
    private double unit_price = 0;
    //餐盒費
    private double lunchboxPrice = 0;
    //食品類型（1+主食品，2=套餐食品，3=套餐下細項）
    private int itemType = 1;
    //是否食品
    private boolean isIsfood = true;
    //父級下標
    private int parentIndex = 0;
    //自身下標
    private int myIndex = 0;
    //是否是新添加的食品（未送單）
    private boolean isNew = true;
    //是否顯示
    private boolean visible = true;
    //新点后是否自动展开
    private int autoMod = 0;
    //作用于套餐下子食品的限制数量
    private int limitQty = 0;
    //最后的金额平均数(Famount_price/number)
    private double Famount_price_sign = 0;
    //是否组合商品 1-组合商品 2-组合商品的子商品
    private int ComboLevel = 0;
    //折扣比例
    private double PERCENTAGE = 0.00;
    //"food" or "discount" or "modifiy"
    private String prop = "food";
    //套餐食品是否自動跟餐
    private boolean isComboAuto = false;
    //当作为套餐内时的编號
    private String comid = "";
    //修改数量前的数量
    private int changeBeforeQty = 0;
    //当前食品是否有子项
    private boolean hasChild = false;
    //背景色
    private int bgColor;
    //字體色
    private int fontColor;

    //保存訂單id
    private long orderId;
    //fid
    private long fid;
    //父級fid
    private long parentId;

    private String printseting;

    public OrderDetail() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLunchboxPrice() {
        return lunchboxPrice;
    }

    public void setLunchboxPrice(double lunchboxPrice) {
        this.lunchboxPrice = lunchboxPrice;
    }

    public long getParentId() {
        return parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public long getOrderId() {
        return orderId;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    public int getSelected() {
        return selected;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public int getNumber() {
        return number;
    }

    public long getFid() {
        return fid;
    }

    public void setFid(long fid) {
        this.fid = fid;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public double getAmount_price() {
        return amount_price;
    }

    public void setAmount_price(double amount_price) {
        this.amount_price = amount_price;
    }

    public int getItemType() {
        return itemType;
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    public boolean isIsfood() {
        return isIsfood;
    }

    public void setIsfood(boolean isfood) {
        isIsfood = isfood;
    }

    public int getParentIndex() {
        return parentIndex;
    }

    public void setParentIndex(int parentIndex) {
        this.parentIndex = parentIndex;
    }

    public int getMyIndex() {
        return myIndex;
    }

    public void setMyIndex(int myIndex) {
        this.myIndex = myIndex;
    }

    public boolean isNew() {
        return isNew;
    }

    public void setNew(boolean aNew) {
        isNew = aNew;
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }


    public int getAutoMod() {
        return autoMod;
    }

    public void setAutoMod(int autoMod) {
        this.autoMod = autoMod;
    }

    public int getLimitQty() {
        return limitQty;
    }

    public void setLimitQty(int limitQty) {
        this.limitQty = limitQty;
    }

    public double getFamount_price_sign() {
        return Famount_price_sign;
    }

    public void setFamount_price_sign(double famount_price_sign) {
        Famount_price_sign = famount_price_sign;
    }

    public int getComboLevel() {
        return ComboLevel;
    }

    public void setComboLevel(int comboLevel) {
        ComboLevel = comboLevel;
    }

    public double getPERCENTAGE() {
        return PERCENTAGE;
    }

    public void setPERCENTAGE(double PERCENTAGE) {
        this.PERCENTAGE = PERCENTAGE;
    }

    public String getProp() {
        return prop;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }

    public boolean isComboAuto() {
        return isComboAuto;
    }

    public void setComboAuto(boolean comboAuto) {
        isComboAuto = comboAuto;
    }

    public String getComid() {
        return comid;
    }

    public void setComid(String comid) {
        this.comid = comid;
    }

    public int getChangeBeforeQty() {
        return changeBeforeQty;
    }

    public void setChangeBeforeQty(int changeBeforeQty) {
        this.changeBeforeQty = changeBeforeQty;
    }

    public boolean isHasChild() {
        return hasChild;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }

    public int getBgColor() {
        return bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public int getFontColor() {
        return fontColor;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public double getUnit_price() {
        return unit_price;
    }

    public void setUnit_price(double unit_price) {
        this.unit_price = unit_price;
    }

    public String getPrintseting() {
        return printseting;
    }

    public void setPrintseting(String printseting) {
        this.printseting = printseting;
    }

    /**
     * 已送單食品轉換
     *
     * @param orderDetails
     * @return
     */
    public static List<OrderDetail> orderTransOrderDetails(List<OrderBean.OrderDetailsBean> orderDetails) {
        List<OrderDetail> orderDetailList = new ArrayList<>();
        for (OrderBean.OrderDetailsBean orderDetailsBean : orderDetails) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setFid(orderDetailsBean.getId());
            orderDetail.setOrderId(orderDetailsBean.getOrderId());
            orderDetail.setName(orderDetailsBean.getProductName());
            orderDetail.setNumber(orderDetailsBean.getNumber());
            orderDetail.setAmount_price(orderDetailsBean.getPrice());
            orderDetail.setVisible(orderDetailsBean.getStatus() == 0);
//            orderDetail.setAutomod(foods.getAutomod());//TODO 需接口返回
            orderDetail.setIsfood(true);//TODO 需接口返回
            orderDetail.setItemType(1);//TODO 需接口返回
            //            orderDetail.setProp("food");
            orderDetail.setNew(false);
            orderDetailList.add(orderDetail);
        }
        return orderDetailList;
    }

    /**
     * 主食品轉換
     *
     * @param foods
     * @param number
     * @return
     */
    public static OrderDetail foodTransOrderDetails(Food foods, int number) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setName(foods.getFoodName());
        orderDetail.setFid(foods.getId());
        orderDetail.setUnit_price(foods.getPrice());
        orderDetail.setAmount_price(number * orderDetail.getUnit_price());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MyOrderManage.getInstance().getOrderId());
        orderDetail.setIsfood(true);
        orderDetail.setNew(true);
        orderDetail.setItemType(1);
        orderDetail.setProp("food");
        orderDetail.setAutoMod(foods.getAutoMod());
        return orderDetail;
    }

    /**
     * 套餐食品轉換
     *
     * @param combo
     * @param number
     * @param prop
     * @param isRvMealClicked
     * @return
     */
    public static OrderDetail comboTransOrderDetail(Combo combo, int number, String prop, boolean isRvMealClicked) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setName(combo.getName());
        orderDetail.setFid(combo.getFid());
        orderDetail.setUnit_price(combo.getPrice());
        orderDetail.setAmount_price(number * orderDetail.getUnit_price());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MyOrderManage.getInstance().getOrderId());
        orderDetail.setIsfood(true);
        orderDetail.setNew(true);
        orderDetail.setItemType(2);
        orderDetail.setProp(prop);
//        orderDetail.setComboAuto(combo.isAutoMode());
        if (isRvMealClicked) {
            //手动点击细项 才将子食品作为主体被选中
            orderDetail.setSelected(2);
        } else {
            orderDetail.setSelected(1);
        }
        return orderDetail;
    }


    /**
     * 細項轉換
     *
     * @param modifier
     * @param number
     * @return
     */
    public static OrderDetail modifierTransOrderDetail(Modifier modifier, int number) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setName(modifier.getModifierName());
        orderDetail.setFid(modifier.getMid());
        orderDetail.setUnit_price(modifier.getPrice());
        orderDetail.setAmount_price(number * orderDetail.getUnit_price());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MyOrderManage.getInstance().getOrderId());
        orderDetail.setIsfood(false);
        orderDetail.setNew(true);
        orderDetail.setItemType(3);
        orderDetail.setProp("modifify");
        //手动点击细项 才将子食品作为主体被选中
        orderDetail.setSelected(2);
        return orderDetail;
    }


}
