package com.gingersoft.gsa.cloud.database.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.query.Query;
import org.greenrobot.greendao.query.QueryBuilder;

import com.gingersoft.gsa.cloud.database.bean.Food;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD".
*/
public class FoodDao extends AbstractDao<Food, Long> {

    public static final String TABLENAME = "FOOD";

    /**
     * Properties of entity Food.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Id = new Property(1, Long.class, "id", false, "ID");
        public final static Property ParentId = new Property(2, Long.class, "parentId", false, "PARENT_ID");
        public final static Property RestaurantId = new Property(3, Long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property Fid = new Property(4, String.class, "fid", false, "FID");
        public final static Property IsParent = new Property(5, Byte.class, "isParent", false, "IS_PARENT");
        public final static Property SeqNo = new Property(6, Long.class, "seqNo", false, "SEQ_NO");
        public final static Property FoodName = new Property(7, String.class, "foodName", false, "FOOD_NAME");
        public final static Property PosFid = new Property(8, String.class, "posFid", false, "POS_FID");
        public final static Property FoodDesc = new Property(9, String.class, "foodDesc", false, "FOOD_DESC");
        public final static Property LimitAmount = new Property(10, Long.class, "limitAmount", false, "LIMIT_AMOUNT");
        public final static Property LimitType = new Property(11, Long.class, "limitType", false, "LIMIT_TYPE");
        public final static Property FoodSummary = new Property(12, Long.class, "foodSummary", false, "FOOD_SUMMARY");
        public final static Property Invisible = new Property(13, Long.class, "invisible", false, "INVISIBLE");
        public final static Property AutoMod = new Property(14, Byte.class, "autoMod", false, "AUTO_MOD");
        public final static Property Price = new Property(15, Double.class, "price", false, "PRICE");
        public final static Property MarketPrice = new Property(16, Double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property LunchboxPrice = new Property(17, Double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ImgUrlSmall = new Property(18, String.class, "imgUrlSmall", false, "IMG_URL_SMALL");
        public final static Property Imageurl = new Property(19, String.class, "imageurl", false, "IMAGEURL");
        public final static Property RiceponInvisible = new Property(20, Long.class, "riceponInvisible", false, "RICEPON_INVISIBLE");
        public final static Property Cost = new Property(21, Double.class, "cost", false, "COST");
        public final static Property StartDate = new Property(22, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(23, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property Like = new Property(24, Long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(25, Long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property IsSold = new Property(26, Long.class, "isSold", false, "IS_SOLD");
        public final static Property CreateBy = new Property(27, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(28, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(29, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(30, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PeriodId = new Property(31, Long.class, "periodId", false, "PERIOD_ID");
        public final static Property AbleDiscount = new Property(32, Long.class, "ableDiscount", false, "ABLE_DISCOUNT");
        public final static Property Takeaway = new Property(33, Long.class, "takeaway", false, "TAKEAWAY");
        public final static Property BlueEdit = new Property(34, Long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property CartEdit = new Property(35, Long.class, "cartEdit", false, "CART_EDIT");
        public final static Property AutoMerge = new Property(36, Long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property FoodName1 = new Property(37, String.class, "foodName1", false, "FOOD_NAME1");
        public final static Property FoodName2 = new Property(38, String.class, "foodName2", false, "FOOD_NAME2");
        public final static Property Plu = new Property(39, String.class, "plu", false, "PLU");
        public final static Property PrintSeting = new Property(40, String.class, "printSeting", false, "PRINT_SETING");
        public final static Property IsPrintQueueCode = new Property(41, Long.class, "isPrintQueueCode", false, "IS_PRINT_QUEUE_CODE");
        public final static Property QueueHeadId = new Property(42, Long.class, "queueHeadId", false, "QUEUE_HEAD_ID");
        public final static Property Approve = new Property(43, Long.class, "approve", false, "APPROVE");
        public final static Property PrintFont = new Property(44, Long.class, "printFont", false, "PRINT_FONT");
        public final static Property AdvPrice = new Property(45, Long.class, "advPrice", false, "ADV_PRICE");
        public final static Property PrintToBill = new Property(46, Long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property PointsAdd = new Property(47, Double.class, "pointsAdd", false, "POINTS_ADD");
        public final static Property PointsRatio = new Property(48, Long.class, "pointsRatio", false, "POINTS_RATIO");
        public final static Property PointsRedeem = new Property(49, Double.class, "pointsRedeem", false, "POINTS_REDEEM");
        public final static Property KtPrintMainItem = new Property(50, Long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(51, Long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property PrintTo = new Property(52, Long.class, "printTo", false, "PRINT_TO");
        public final static Property ToPax = new Property(53, Long.class, "toPax", false, "TO_PAX");
        public final static Property FoodType = new Property(54, Long.class, "foodType", false, "FOOD_TYPE");
        public final static Property MajorMainId = new Property(55, Long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(56, Long.class, "deptId", false, "DEPT_ID");
        public final static Property ServiceCharge = new Property(57, Byte.class, "serviceCharge", false, "SERVICE_CHARGE");
        public final static Property ColorId = new Property(58, Long.class, "colorId", false, "COLOR_ID");
        public final static Property Conditions = new Property(59, Long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(60, Long.class, "isRt", false, "IS_RT");
        public final static Property Deletes = new Property(61, Long.class, "deletes", false, "DELETES");
        public final static Property IsTimingFood = new Property(62, Long.class, "isTimingFood", false, "IS_TIMING_FOOD");
        public final static Property MinLongTime = new Property(63, Long.class, "minLongTime", false, "MIN_LONG_TIME");
        public final static Property UnitTime = new Property(64, Long.class, "unitTime", false, "UNIT_TIME");
        public final static Property UnitPrice = new Property(65, Double.class, "unitPrice", false, "UNIT_PRICE");
        public final static Property FreeLongTime = new Property(66, Long.class, "freeLongTime", false, "FREE_LONG_TIME");
        public final static Property FreePeriodBegin = new Property(67, java.util.Date.class, "freePeriodBegin", false, "FREE_PERIOD_BEGIN");
        public final static Property IsStatistic = new Property(68, Long.class, "isStatistic", false, "IS_STATISTIC");
    }

    private Query<Food> combo_FoodsQuery;

    public FoodDao(DaoConfig config) {
        super(config);
    }
    
    public FoodDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"ID\" INTEGER," + // 1: id
                "\"PARENT_ID\" INTEGER," + // 2: parentId
                "\"RESTAURANT_ID\" INTEGER," + // 3: restaurantId
                "\"FID\" TEXT," + // 4: fid
                "\"IS_PARENT\" INTEGER," + // 5: isParent
                "\"SEQ_NO\" INTEGER," + // 6: seqNo
                "\"FOOD_NAME\" TEXT," + // 7: foodName
                "\"POS_FID\" TEXT," + // 8: posFid
                "\"FOOD_DESC\" TEXT," + // 9: foodDesc
                "\"LIMIT_AMOUNT\" INTEGER," + // 10: limitAmount
                "\"LIMIT_TYPE\" INTEGER," + // 11: limitType
                "\"FOOD_SUMMARY\" INTEGER," + // 12: foodSummary
                "\"INVISIBLE\" INTEGER," + // 13: invisible
                "\"AUTO_MOD\" INTEGER," + // 14: autoMod
                "\"PRICE\" REAL," + // 15: price
                "\"MARKET_PRICE\" REAL," + // 16: marketPrice
                "\"LUNCHBOX_PRICE\" REAL," + // 17: lunchboxPrice
                "\"IMG_URL_SMALL\" TEXT," + // 18: imgUrlSmall
                "\"IMAGEURL\" TEXT," + // 19: imageurl
                "\"RICEPON_INVISIBLE\" INTEGER," + // 20: riceponInvisible
                "\"COST\" REAL," + // 21: cost
                "\"START_DATE\" INTEGER," + // 22: startDate
                "\"END_DATE\" INTEGER," + // 23: endDate
                "\"LIKE\" INTEGER," + // 24: like
                "\"TOTAL_SOLD\" INTEGER," + // 25: totalSold
                "\"IS_SOLD\" INTEGER," + // 26: isSold
                "\"CREATE_BY\" TEXT," + // 27: createBy
                "\"CREATE_TIME\" INTEGER," + // 28: createTime
                "\"UPDATE_BY\" TEXT," + // 29: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 30: updateTime
                "\"PERIOD_ID\" INTEGER," + // 31: periodId
                "\"ABLE_DISCOUNT\" INTEGER," + // 32: ableDiscount
                "\"TAKEAWAY\" INTEGER," + // 33: takeaway
                "\"BLUE_EDIT\" INTEGER," + // 34: blueEdit
                "\"CART_EDIT\" INTEGER," + // 35: cartEdit
                "\"AUTO_MERGE\" INTEGER," + // 36: autoMerge
                "\"FOOD_NAME1\" TEXT," + // 37: foodName1
                "\"FOOD_NAME2\" TEXT," + // 38: foodName2
                "\"PLU\" TEXT," + // 39: plu
                "\"PRINT_SETING\" TEXT," + // 40: printSeting
                "\"IS_PRINT_QUEUE_CODE\" INTEGER," + // 41: isPrintQueueCode
                "\"QUEUE_HEAD_ID\" INTEGER," + // 42: queueHeadId
                "\"APPROVE\" INTEGER," + // 43: approve
                "\"PRINT_FONT\" INTEGER," + // 44: printFont
                "\"ADV_PRICE\" INTEGER," + // 45: advPrice
                "\"PRINT_TO_BILL\" INTEGER," + // 46: printToBill
                "\"POINTS_ADD\" REAL," + // 47: pointsAdd
                "\"POINTS_RATIO\" INTEGER," + // 48: pointsRatio
                "\"POINTS_REDEEM\" REAL," + // 49: pointsRedeem
                "\"KT_PRINT_MAIN_ITEM\" INTEGER," + // 50: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER," + // 51: ktShowPrice
                "\"PRINT_TO\" INTEGER," + // 52: printTo
                "\"TO_PAX\" INTEGER," + // 53: toPax
                "\"FOOD_TYPE\" INTEGER," + // 54: foodType
                "\"MAJOR_MAIN_ID\" INTEGER," + // 55: majorMainId
                "\"DEPT_ID\" INTEGER," + // 56: deptId
                "\"SERVICE_CHARGE\" INTEGER," + // 57: serviceCharge
                "\"COLOR_ID\" INTEGER," + // 58: colorId
                "\"CONDITIONS\" INTEGER," + // 59: conditions
                "\"IS_RT\" INTEGER," + // 60: isRt
                "\"DELETES\" INTEGER," + // 61: deletes
                "\"IS_TIMING_FOOD\" INTEGER," + // 62: isTimingFood
                "\"MIN_LONG_TIME\" INTEGER," + // 63: minLongTime
                "\"UNIT_TIME\" INTEGER," + // 64: unitTime
                "\"UNIT_PRICE\" REAL," + // 65: unitPrice
                "\"FREE_LONG_TIME\" INTEGER," + // 66: freeLongTime
                "\"FREE_PERIOD_BEGIN\" INTEGER," + // 67: freePeriodBegin
                "\"IS_STATISTIC\" INTEGER);"); // 68: isStatistic
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(2, id);
        }
 
        Long parentId = entity.getParentId();
        if (parentId != null) {
            stmt.bindLong(3, parentId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String fid = entity.getFid();
        if (fid != null) {
            stmt.bindString(5, fid);
        }
 
        Byte isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(6, isParent);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(7, seqNo);
        }
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(8, foodName);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(9, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(10, foodDesc);
        }
 
        Long limitAmount = entity.getLimitAmount();
        if (limitAmount != null) {
            stmt.bindLong(11, limitAmount);
        }
 
        Long limitType = entity.getLimitType();
        if (limitType != null) {
            stmt.bindLong(12, limitType);
        }
 
        Long foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindLong(13, foodSummary);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(14, invisible);
        }
 
        Byte autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(15, autoMod);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(16, price);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(17, marketPrice);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(18, lunchboxPrice);
        }
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(19, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(20, imageurl);
        }
 
        Long riceponInvisible = entity.getRiceponInvisible();
        if (riceponInvisible != null) {
            stmt.bindLong(21, riceponInvisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(22, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(23, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(24, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(25, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(26, totalSold);
        }
 
        Long isSold = entity.getIsSold();
        if (isSold != null) {
            stmt.bindLong(27, isSold);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(28, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(29, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(30, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(31, updateTime.getTime());
        }
 
        Long periodId = entity.getPeriodId();
        if (periodId != null) {
            stmt.bindLong(32, periodId);
        }
 
        Long ableDiscount = entity.getAbleDiscount();
        if (ableDiscount != null) {
            stmt.bindLong(33, ableDiscount);
        }
 
        Long takeaway = entity.getTakeaway();
        if (takeaway != null) {
            stmt.bindLong(34, takeaway);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(35, blueEdit);
        }
 
        Long cartEdit = entity.getCartEdit();
        if (cartEdit != null) {
            stmt.bindLong(36, cartEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(37, autoMerge);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(38, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(39, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(40, plu);
        }
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(41, printSeting);
        }
 
        Long isPrintQueueCode = entity.getIsPrintQueueCode();
        if (isPrintQueueCode != null) {
            stmt.bindLong(42, isPrintQueueCode);
        }
 
        Long queueHeadId = entity.getQueueHeadId();
        if (queueHeadId != null) {
            stmt.bindLong(43, queueHeadId);
        }
 
        Long approve = entity.getApprove();
        if (approve != null) {
            stmt.bindLong(44, approve);
        }
 
        Long printFont = entity.getPrintFont();
        if (printFont != null) {
            stmt.bindLong(45, printFont);
        }
 
        Long advPrice = entity.getAdvPrice();
        if (advPrice != null) {
            stmt.bindLong(46, advPrice);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(47, printToBill);
        }
 
        Double pointsAdd = entity.getPointsAdd();
        if (pointsAdd != null) {
            stmt.bindDouble(48, pointsAdd);
        }
 
        Long pointsRatio = entity.getPointsRatio();
        if (pointsRatio != null) {
            stmt.bindLong(49, pointsRatio);
        }
 
        Double pointsRedeem = entity.getPointsRedeem();
        if (pointsRedeem != null) {
            stmt.bindDouble(50, pointsRedeem);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(51, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(52, ktShowPrice);
        }
 
        Long printTo = entity.getPrintTo();
        if (printTo != null) {
            stmt.bindLong(53, printTo);
        }
 
        Long toPax = entity.getToPax();
        if (toPax != null) {
            stmt.bindLong(54, toPax);
        }
 
        Long foodType = entity.getFoodType();
        if (foodType != null) {
            stmt.bindLong(55, foodType);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(56, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(57, deptId);
        }
 
        Byte serviceCharge = entity.getServiceCharge();
        if (serviceCharge != null) {
            stmt.bindLong(58, serviceCharge);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(59, colorId);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(60, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(61, isRt);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(62, deletes);
        }
 
        Long isTimingFood = entity.getIsTimingFood();
        if (isTimingFood != null) {
            stmt.bindLong(63, isTimingFood);
        }
 
        Long minLongTime = entity.getMinLongTime();
        if (minLongTime != null) {
            stmt.bindLong(64, minLongTime);
        }
 
        Long unitTime = entity.getUnitTime();
        if (unitTime != null) {
            stmt.bindLong(65, unitTime);
        }
 
        Double unitPrice = entity.getUnitPrice();
        if (unitPrice != null) {
            stmt.bindDouble(66, unitPrice);
        }
 
        Long freeLongTime = entity.getFreeLongTime();
        if (freeLongTime != null) {
            stmt.bindLong(67, freeLongTime);
        }
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(68, freePeriodBegin.getTime());
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(69, isStatistic);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(2, id);
        }
 
        Long parentId = entity.getParentId();
        if (parentId != null) {
            stmt.bindLong(3, parentId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String fid = entity.getFid();
        if (fid != null) {
            stmt.bindString(5, fid);
        }
 
        Byte isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(6, isParent);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(7, seqNo);
        }
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(8, foodName);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(9, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(10, foodDesc);
        }
 
        Long limitAmount = entity.getLimitAmount();
        if (limitAmount != null) {
            stmt.bindLong(11, limitAmount);
        }
 
        Long limitType = entity.getLimitType();
        if (limitType != null) {
            stmt.bindLong(12, limitType);
        }
 
        Long foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindLong(13, foodSummary);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(14, invisible);
        }
 
        Byte autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(15, autoMod);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(16, price);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(17, marketPrice);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(18, lunchboxPrice);
        }
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(19, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(20, imageurl);
        }
 
        Long riceponInvisible = entity.getRiceponInvisible();
        if (riceponInvisible != null) {
            stmt.bindLong(21, riceponInvisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(22, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(23, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(24, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(25, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(26, totalSold);
        }
 
        Long isSold = entity.getIsSold();
        if (isSold != null) {
            stmt.bindLong(27, isSold);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(28, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(29, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(30, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(31, updateTime.getTime());
        }
 
        Long periodId = entity.getPeriodId();
        if (periodId != null) {
            stmt.bindLong(32, periodId);
        }
 
        Long ableDiscount = entity.getAbleDiscount();
        if (ableDiscount != null) {
            stmt.bindLong(33, ableDiscount);
        }
 
        Long takeaway = entity.getTakeaway();
        if (takeaway != null) {
            stmt.bindLong(34, takeaway);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(35, blueEdit);
        }
 
        Long cartEdit = entity.getCartEdit();
        if (cartEdit != null) {
            stmt.bindLong(36, cartEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(37, autoMerge);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(38, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(39, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(40, plu);
        }
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(41, printSeting);
        }
 
        Long isPrintQueueCode = entity.getIsPrintQueueCode();
        if (isPrintQueueCode != null) {
            stmt.bindLong(42, isPrintQueueCode);
        }
 
        Long queueHeadId = entity.getQueueHeadId();
        if (queueHeadId != null) {
            stmt.bindLong(43, queueHeadId);
        }
 
        Long approve = entity.getApprove();
        if (approve != null) {
            stmt.bindLong(44, approve);
        }
 
        Long printFont = entity.getPrintFont();
        if (printFont != null) {
            stmt.bindLong(45, printFont);
        }
 
        Long advPrice = entity.getAdvPrice();
        if (advPrice != null) {
            stmt.bindLong(46, advPrice);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(47, printToBill);
        }
 
        Double pointsAdd = entity.getPointsAdd();
        if (pointsAdd != null) {
            stmt.bindDouble(48, pointsAdd);
        }
 
        Long pointsRatio = entity.getPointsRatio();
        if (pointsRatio != null) {
            stmt.bindLong(49, pointsRatio);
        }
 
        Double pointsRedeem = entity.getPointsRedeem();
        if (pointsRedeem != null) {
            stmt.bindDouble(50, pointsRedeem);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(51, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(52, ktShowPrice);
        }
 
        Long printTo = entity.getPrintTo();
        if (printTo != null) {
            stmt.bindLong(53, printTo);
        }
 
        Long toPax = entity.getToPax();
        if (toPax != null) {
            stmt.bindLong(54, toPax);
        }
 
        Long foodType = entity.getFoodType();
        if (foodType != null) {
            stmt.bindLong(55, foodType);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(56, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(57, deptId);
        }
 
        Byte serviceCharge = entity.getServiceCharge();
        if (serviceCharge != null) {
            stmt.bindLong(58, serviceCharge);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(59, colorId);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(60, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(61, isRt);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(62, deletes);
        }
 
        Long isTimingFood = entity.getIsTimingFood();
        if (isTimingFood != null) {
            stmt.bindLong(63, isTimingFood);
        }
 
        Long minLongTime = entity.getMinLongTime();
        if (minLongTime != null) {
            stmt.bindLong(64, minLongTime);
        }
 
        Long unitTime = entity.getUnitTime();
        if (unitTime != null) {
            stmt.bindLong(65, unitTime);
        }
 
        Double unitPrice = entity.getUnitPrice();
        if (unitPrice != null) {
            stmt.bindDouble(66, unitPrice);
        }
 
        Long freeLongTime = entity.getFreeLongTime();
        if (freeLongTime != null) {
            stmt.bindLong(67, freeLongTime);
        }
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(68, freePeriodBegin.getTime());
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(69, isStatistic);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Food readEntity(Cursor cursor, int offset) {
        Food entity = new Food( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // id
            cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2), // parentId
            cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3), // restaurantId
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // fid
            cursor.isNull(offset + 5) ? null : (byte) cursor.getShort(offset + 5), // isParent
            cursor.isNull(offset + 6) ? null : cursor.getLong(offset + 6), // seqNo
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // foodName
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // posFid
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // foodDesc
            cursor.isNull(offset + 10) ? null : cursor.getLong(offset + 10), // limitAmount
            cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11), // limitType
            cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12), // foodSummary
            cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13), // invisible
            cursor.isNull(offset + 14) ? null : (byte) cursor.getShort(offset + 14), // autoMod
            cursor.isNull(offset + 15) ? null : cursor.getDouble(offset + 15), // price
            cursor.isNull(offset + 16) ? null : cursor.getDouble(offset + 16), // marketPrice
            cursor.isNull(offset + 17) ? null : cursor.getDouble(offset + 17), // lunchboxPrice
            cursor.isNull(offset + 18) ? null : cursor.getString(offset + 18), // imgUrlSmall
            cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19), // imageurl
            cursor.isNull(offset + 20) ? null : cursor.getLong(offset + 20), // riceponInvisible
            cursor.isNull(offset + 21) ? null : cursor.getDouble(offset + 21), // cost
            cursor.isNull(offset + 22) ? null : new java.util.Date(cursor.getLong(offset + 22)), // startDate
            cursor.isNull(offset + 23) ? null : new java.util.Date(cursor.getLong(offset + 23)), // endDate
            cursor.isNull(offset + 24) ? null : cursor.getLong(offset + 24), // like
            cursor.isNull(offset + 25) ? null : cursor.getLong(offset + 25), // totalSold
            cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26), // isSold
            cursor.isNull(offset + 27) ? null : cursor.getString(offset + 27), // createBy
            cursor.isNull(offset + 28) ? null : new java.util.Date(cursor.getLong(offset + 28)), // createTime
            cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29), // updateBy
            cursor.isNull(offset + 30) ? null : new java.util.Date(cursor.getLong(offset + 30)), // updateTime
            cursor.isNull(offset + 31) ? null : cursor.getLong(offset + 31), // periodId
            cursor.isNull(offset + 32) ? null : cursor.getLong(offset + 32), // ableDiscount
            cursor.isNull(offset + 33) ? null : cursor.getLong(offset + 33), // takeaway
            cursor.isNull(offset + 34) ? null : cursor.getLong(offset + 34), // blueEdit
            cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35), // cartEdit
            cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36), // autoMerge
            cursor.isNull(offset + 37) ? null : cursor.getString(offset + 37), // foodName1
            cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38), // foodName2
            cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39), // plu
            cursor.isNull(offset + 40) ? null : cursor.getString(offset + 40), // printSeting
            cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41), // isPrintQueueCode
            cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42), // queueHeadId
            cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43), // approve
            cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44), // printFont
            cursor.isNull(offset + 45) ? null : cursor.getLong(offset + 45), // advPrice
            cursor.isNull(offset + 46) ? null : cursor.getLong(offset + 46), // printToBill
            cursor.isNull(offset + 47) ? null : cursor.getDouble(offset + 47), // pointsAdd
            cursor.isNull(offset + 48) ? null : cursor.getLong(offset + 48), // pointsRatio
            cursor.isNull(offset + 49) ? null : cursor.getDouble(offset + 49), // pointsRedeem
            cursor.isNull(offset + 50) ? null : cursor.getLong(offset + 50), // ktPrintMainItem
            cursor.isNull(offset + 51) ? null : cursor.getLong(offset + 51), // ktShowPrice
            cursor.isNull(offset + 52) ? null : cursor.getLong(offset + 52), // printTo
            cursor.isNull(offset + 53) ? null : cursor.getLong(offset + 53), // toPax
            cursor.isNull(offset + 54) ? null : cursor.getLong(offset + 54), // foodType
            cursor.isNull(offset + 55) ? null : cursor.getLong(offset + 55), // majorMainId
            cursor.isNull(offset + 56) ? null : cursor.getLong(offset + 56), // deptId
            cursor.isNull(offset + 57) ? null : (byte) cursor.getShort(offset + 57), // serviceCharge
            cursor.isNull(offset + 58) ? null : cursor.getLong(offset + 58), // colorId
            cursor.isNull(offset + 59) ? null : cursor.getLong(offset + 59), // conditions
            cursor.isNull(offset + 60) ? null : cursor.getLong(offset + 60), // isRt
            cursor.isNull(offset + 61) ? null : cursor.getLong(offset + 61), // deletes
            cursor.isNull(offset + 62) ? null : cursor.getLong(offset + 62), // isTimingFood
            cursor.isNull(offset + 63) ? null : cursor.getLong(offset + 63), // minLongTime
            cursor.isNull(offset + 64) ? null : cursor.getLong(offset + 64), // unitTime
            cursor.isNull(offset + 65) ? null : cursor.getDouble(offset + 65), // unitPrice
            cursor.isNull(offset + 66) ? null : cursor.getLong(offset + 66), // freeLongTime
            cursor.isNull(offset + 67) ? null : new java.util.Date(cursor.getLong(offset + 67)), // freePeriodBegin
            cursor.isNull(offset + 68) ? null : cursor.getLong(offset + 68) // isStatistic
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Food entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setId(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setParentId(cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2));
        entity.setRestaurantId(cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3));
        entity.setFid(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setIsParent(cursor.isNull(offset + 5) ? null : (byte) cursor.getShort(offset + 5));
        entity.setSeqNo(cursor.isNull(offset + 6) ? null : cursor.getLong(offset + 6));
        entity.setFoodName(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setPosFid(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setFoodDesc(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setLimitAmount(cursor.isNull(offset + 10) ? null : cursor.getLong(offset + 10));
        entity.setLimitType(cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11));
        entity.setFoodSummary(cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12));
        entity.setInvisible(cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13));
        entity.setAutoMod(cursor.isNull(offset + 14) ? null : (byte) cursor.getShort(offset + 14));
        entity.setPrice(cursor.isNull(offset + 15) ? null : cursor.getDouble(offset + 15));
        entity.setMarketPrice(cursor.isNull(offset + 16) ? null : cursor.getDouble(offset + 16));
        entity.setLunchboxPrice(cursor.isNull(offset + 17) ? null : cursor.getDouble(offset + 17));
        entity.setImgUrlSmall(cursor.isNull(offset + 18) ? null : cursor.getString(offset + 18));
        entity.setImageurl(cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19));
        entity.setRiceponInvisible(cursor.isNull(offset + 20) ? null : cursor.getLong(offset + 20));
        entity.setCost(cursor.isNull(offset + 21) ? null : cursor.getDouble(offset + 21));
        entity.setStartDate(cursor.isNull(offset + 22) ? null : new java.util.Date(cursor.getLong(offset + 22)));
        entity.setEndDate(cursor.isNull(offset + 23) ? null : new java.util.Date(cursor.getLong(offset + 23)));
        entity.setLike(cursor.isNull(offset + 24) ? null : cursor.getLong(offset + 24));
        entity.setTotalSold(cursor.isNull(offset + 25) ? null : cursor.getLong(offset + 25));
        entity.setIsSold(cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26));
        entity.setCreateBy(cursor.isNull(offset + 27) ? null : cursor.getString(offset + 27));
        entity.setCreateTime(cursor.isNull(offset + 28) ? null : new java.util.Date(cursor.getLong(offset + 28)));
        entity.setUpdateBy(cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29));
        entity.setUpdateTime(cursor.isNull(offset + 30) ? null : new java.util.Date(cursor.getLong(offset + 30)));
        entity.setPeriodId(cursor.isNull(offset + 31) ? null : cursor.getLong(offset + 31));
        entity.setAbleDiscount(cursor.isNull(offset + 32) ? null : cursor.getLong(offset + 32));
        entity.setTakeaway(cursor.isNull(offset + 33) ? null : cursor.getLong(offset + 33));
        entity.setBlueEdit(cursor.isNull(offset + 34) ? null : cursor.getLong(offset + 34));
        entity.setCartEdit(cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35));
        entity.setAutoMerge(cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36));
        entity.setFoodName1(cursor.isNull(offset + 37) ? null : cursor.getString(offset + 37));
        entity.setFoodName2(cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38));
        entity.setPlu(cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39));
        entity.setPrintSeting(cursor.isNull(offset + 40) ? null : cursor.getString(offset + 40));
        entity.setIsPrintQueueCode(cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41));
        entity.setQueueHeadId(cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42));
        entity.setApprove(cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43));
        entity.setPrintFont(cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44));
        entity.setAdvPrice(cursor.isNull(offset + 45) ? null : cursor.getLong(offset + 45));
        entity.setPrintToBill(cursor.isNull(offset + 46) ? null : cursor.getLong(offset + 46));
        entity.setPointsAdd(cursor.isNull(offset + 47) ? null : cursor.getDouble(offset + 47));
        entity.setPointsRatio(cursor.isNull(offset + 48) ? null : cursor.getLong(offset + 48));
        entity.setPointsRedeem(cursor.isNull(offset + 49) ? null : cursor.getDouble(offset + 49));
        entity.setKtPrintMainItem(cursor.isNull(offset + 50) ? null : cursor.getLong(offset + 50));
        entity.setKtShowPrice(cursor.isNull(offset + 51) ? null : cursor.getLong(offset + 51));
        entity.setPrintTo(cursor.isNull(offset + 52) ? null : cursor.getLong(offset + 52));
        entity.setToPax(cursor.isNull(offset + 53) ? null : cursor.getLong(offset + 53));
        entity.setFoodType(cursor.isNull(offset + 54) ? null : cursor.getLong(offset + 54));
        entity.setMajorMainId(cursor.isNull(offset + 55) ? null : cursor.getLong(offset + 55));
        entity.setDeptId(cursor.isNull(offset + 56) ? null : cursor.getLong(offset + 56));
        entity.setServiceCharge(cursor.isNull(offset + 57) ? null : (byte) cursor.getShort(offset + 57));
        entity.setColorId(cursor.isNull(offset + 58) ? null : cursor.getLong(offset + 58));
        entity.setConditions(cursor.isNull(offset + 59) ? null : cursor.getLong(offset + 59));
        entity.setIsRt(cursor.isNull(offset + 60) ? null : cursor.getLong(offset + 60));
        entity.setDeletes(cursor.isNull(offset + 61) ? null : cursor.getLong(offset + 61));
        entity.setIsTimingFood(cursor.isNull(offset + 62) ? null : cursor.getLong(offset + 62));
        entity.setMinLongTime(cursor.isNull(offset + 63) ? null : cursor.getLong(offset + 63));
        entity.setUnitTime(cursor.isNull(offset + 64) ? null : cursor.getLong(offset + 64));
        entity.setUnitPrice(cursor.isNull(offset + 65) ? null : cursor.getDouble(offset + 65));
        entity.setFreeLongTime(cursor.isNull(offset + 66) ? null : cursor.getLong(offset + 66));
        entity.setFreePeriodBegin(cursor.isNull(offset + 67) ? null : new java.util.Date(cursor.getLong(offset + 67)));
        entity.setIsStatistic(cursor.isNull(offset + 68) ? null : cursor.getLong(offset + 68));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Food entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Food entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Food entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "foods" to-many relationship of Combo. */
    public List<Food> _queryCombo_Foods(Long id) {
        synchronized (this) {
            if (combo_FoodsQuery == null) {
                QueryBuilder<Food> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.Id.eq(null));
                combo_FoodsQuery = queryBuilder.build();
            }
        }
        Query<Food> query = combo_FoodsQuery.forCurrentThread();
        query.setParameter(0, id);
        return query.list();
    }

}
