package com.gingersoft.gsa.cloud.database.greendao;

import java.util.Map;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.DaoConfig;

import com.gingersoft.gsa.cloud.database.bean.Combo;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import com.gingersoft.gsa.cloud.database.greendao.ComboDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.FunctionDao;
import com.gingersoft.gsa.cloud.database.greendao.ModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.PrinterDeviceBeanDao;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see org.greenrobot.greendao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig comboDaoConfig;
    private final DaoConfig foodDaoConfig;
    private final DaoConfig foodModifierDaoConfig;
    private final DaoConfig functionDaoConfig;
    private final DaoConfig modifierDaoConfig;
    private final DaoConfig printerDeviceBeanDaoConfig;

    private final ComboDao comboDao;
    private final FoodDao foodDao;
    private final FoodModifierDao foodModifierDao;
    private final FunctionDao functionDao;
    private final ModifierDao modifierDao;
    private final PrinterDeviceBeanDao printerDeviceBeanDao;

    public DaoSession(Database db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        comboDaoConfig = daoConfigMap.get(ComboDao.class).clone();
        comboDaoConfig.initIdentityScope(type);

        foodDaoConfig = daoConfigMap.get(FoodDao.class).clone();
        foodDaoConfig.initIdentityScope(type);

        foodModifierDaoConfig = daoConfigMap.get(FoodModifierDao.class).clone();
        foodModifierDaoConfig.initIdentityScope(type);

        functionDaoConfig = daoConfigMap.get(FunctionDao.class).clone();
        functionDaoConfig.initIdentityScope(type);

        modifierDaoConfig = daoConfigMap.get(ModifierDao.class).clone();
        modifierDaoConfig.initIdentityScope(type);

        printerDeviceBeanDaoConfig = daoConfigMap.get(PrinterDeviceBeanDao.class).clone();
        printerDeviceBeanDaoConfig.initIdentityScope(type);

        comboDao = new ComboDao(comboDaoConfig, this);
        foodDao = new FoodDao(foodDaoConfig, this);
        foodModifierDao = new FoodModifierDao(foodModifierDaoConfig, this);
        functionDao = new FunctionDao(functionDaoConfig, this);
        modifierDao = new ModifierDao(modifierDaoConfig, this);
        printerDeviceBeanDao = new PrinterDeviceBeanDao(printerDeviceBeanDaoConfig, this);

        registerDao(Combo.class, comboDao);
        registerDao(Food.class, foodDao);
        registerDao(FoodModifier.class, foodModifierDao);
        registerDao(Function.class, functionDao);
        registerDao(Modifier.class, modifierDao);
        registerDao(PrinterDeviceBean.class, printerDeviceBeanDao);
    }
    
    public void clear() {
        comboDaoConfig.clearIdentityScope();
        foodDaoConfig.clearIdentityScope();
        foodModifierDaoConfig.clearIdentityScope();
        functionDaoConfig.clearIdentityScope();
        modifierDaoConfig.clearIdentityScope();
        printerDeviceBeanDaoConfig.clearIdentityScope();
    }

    public ComboDao getComboDao() {
        return comboDao;
    }

    public FoodDao getFoodDao() {
        return foodDao;
    }

    public FoodModifierDao getFoodModifierDao() {
        return foodModifierDao;
    }

    public FunctionDao getFunctionDao() {
        return functionDao;
    }

    public ModifierDao getModifierDao() {
        return modifierDao;
    }

    public PrinterDeviceBeanDao getPrinterDeviceBeanDao() {
        return printerDeviceBeanDao;
    }

}
