package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.widget.EditText;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiSelectBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author admin
 */
public class SelectItemProvider<T extends InfoMultiBean> extends InputProvider<T> {
    private Context context;

    public SelectItemProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.EDIT_FOOD_ITEM_SELECT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_multi_select;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T infoMultiBean) {
        super.convert(baseViewHolder, infoMultiBean);
        if (infoMultiBean instanceof MultiSelectBean) {
            MultiSelectBean multiSelectBean = (MultiSelectBean) infoMultiBean;
            EditText editText = baseViewHolder.getView(R.id.ed_multi_value);
            editText.setFocusable(multiSelectBean.isEdit());

//            if (multiSelectBean.isEdit()) {
//                //可以編輯才配置這些
////                KeyListener keyListener = editText.getKeyListener();
////                editText.setKeyListener(keyListener);
//                editText.setFocusable(true);
//            } else {
//                editText.setKeyListener(null);
//            }
            editText.setTextColor(ContextCompat.getColor(context, R.color.color_3c));
        }
    }

    public int getColor(int colorId) {
        return ContextCompat.getColor(context, colorId);
    }
}
