package com.gingersoft.gsa.cloud.main.di.module;

import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.main.mvp.contract.QrCodeContract;
import com.gingersoft.gsa.cloud.main.mvp.model.QrCodeModel;


@Module
public class ErCodeModule {
    private QrCodeContract.View view;

    /**
     * 构建ErCodeModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public ErCodeModule(QrCodeContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    QrCodeContract.View provideErCodeView() {
        return this.view;
    }

    @ActivityScope
    @Provides
    QrCodeContract.Model provideErCodeModel(QrCodeModel model) {
        return model;
    }
}