package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.widget.BaseAdapter;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerMainComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.MainContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.MainPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.HomeFragment;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.MyFragment;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.ReportListFragment;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.arch.QMUIFragmentPagerAdapter;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUIViewPager;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ReportFragment;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/26/2019 14:10
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class MainActivity extends BaseFragmentActivity<MainPresenter> implements MainContract.View {

    //    @BindView(R2.id.topbar)
//    QMUITopBar mTopBar;
//    @BindView(R2.id.gv_function)
//    GridView gv_function;
    @BindView(R2.id.main_pager)
    QMUIViewPager mViewPager;
    @BindView(R2.id.main_tabs)
    QMUITabSegment mTabSegment;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerMainComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.main_activity_main; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTabs();
        initPagers();
    }

    private void initPagers() {
        QMUIFragmentPagerAdapter pagerAdapter = new QMUIFragmentPagerAdapter(getSupportFragmentManager()) {
            @Override
            public Fragment createFragment(int position) {
                switch (position) {
                    case 0:
                        return HomeFragment.newInstance();
                    case 1:
                        return ReportListFragment.newInstance();
                    default:
                        return MyFragment.newInstance();
                }
            }

            @Override
            public int getCount() {
                return 3;
            }

            @Override
            public CharSequence getPageTitle(int position) {
                return "";
            }
        };
        mViewPager.setAdapter(pagerAdapter);
        mTabSegment.setupWithViewPager(mViewPager, false);
    }

    private void initTabs() {
        QMUITabBuilder builder = mTabSegment.tabBuilder();
        builder
                .setSelectedIconScale(1.0f)
                .setTextSize(QMUIDisplayHelper.sp2px(mContext, 14), QMUIDisplayHelper.sp2px(mContext, 14))
                .setNormalIconSizeInfo(75, 75)
                .setDynamicChangeIconColor(false);
        QMUITab home = builder
                .setNormalDrawable(ContextCompat.getDrawable(mContext, R.drawable.ic_normal_main))
                .setSelectedDrawable(ContextCompat.getDrawable(mContext, R.drawable.ic_selected_main))
                .setText(getString(R.string.main))
                .build(mContext);
        QMUITab report = builder
                .setNormalDrawable(ContextCompat.getDrawable(mContext, R.drawable.ic_normal_report))
                .setSelectedDrawable(ContextCompat.getDrawable(mContext, R.drawable.ic_selected_report))
                .setText(getString(R.string.report))
                .build(mContext);
        QMUITab my = builder
                .setNormalDrawable(ContextCompat.getDrawable(mContext, R.drawable.ic_normal_my))
                .setSelectedDrawable(ContextCompat.getDrawable(mContext, R.drawable.ic_selected_my))
                .setText(getString(R.string.my))
                .build(mContext);

        mTabSegment.addTab(home)
                .addTab(report)
                .addTab(my);

    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
//        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
//        mTopBar.addLeftBackImageButton().setVisibility(View.INVISIBLE);
//        mTopBar.setTitle("首頁");
//        mTopBar.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                CC.obtainBuilder(ComponentName.COMPONENT_TABLE)
//                        .setActionName("showTableActivity")
//                        .build()
//                        .call();
//            }
//        });
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
//        ArmsUtils.snackbarText(message);
        ToastUtils.show(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void setFunctionAdapter(BaseAdapter adapter) {
//        gv_function.setAdapter(adapter);
    }

    private long mExitTime;

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if ((System.currentTimeMillis() - mExitTime) > 2000) {
                showMessage("再按一次退出應用");
                mExitTime = System.currentTimeMillis();
            } else {
                finish();
                System.exit(0);
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}
