package com.gingersoft.gsa.cloud.webview.mvp.ui.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.common.webview.WebviewHelper;
import com.gingersoft.gsa.cloud.webview.R;
import com.gingersoft.gsa.cloud.webview.R2;
import com.gingersoft.gsa.cloud.webview.mvp.ui.view.WebViewProgressBar;
import com.gingersoft.gsa.cloud.webview.app.webviewUtils.WebImageListener;
import com.gingersoft.gsa.cloud.webview.app.webviewUtils.WebViewUtils;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;
import com.jess.arms.utils.PermissionUtil;
import com.jess.arms.utils.Preconditions;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.webview.QMUIWebView;
import com.tbruyelle.rxpermissions2.RxPermissions;

import java.util.List;

import javax.inject.Inject;

import butterknife.BindView;
import butterknife.OnClick;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;


public class WebActivity extends BaseActivity<BasePresenter> implements IView {

    @Inject
    RxErrorHandler mErrorHandler;

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.web_view)
    QMUIWebView mWebView;
    @BindView(R2.id.progress_bar)
    WebViewProgressBar mProgressBar;
    @BindView(R2.id.progress_bar1)
    ProgressBar mProgressBar1;
    @BindView(R2.id.tv_hint)
    TextView mTvHint;


    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
//        DaggerWebComponent //如找不到该类,请编译一下项目
//                .builder()
//                .appComponent(appComponent)
//                .webModule(new WebModule(this))
//                .build()
//                .inject(this);
    }

    @Override
    public int initView(Bundle savedInstanceState) {
        return R.layout.activity_web;
    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                killMyself();
            }
        });
        QMUIAlphaImageButton rightButton = mTopBar.addRightImageButton(R.drawable.icon_quick_action_share, R.id.topbar_right_change_button);
        rightButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

            }
        });
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void initData(Bundle savedInstanceState) {

        initWebView();
    }

    @Override
    public void initIntent() {

    }

    @SuppressLint("JavascriptInterface")
    private void initWebView() {
        //使用硬件加速
//        mWebView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);

        WebViewUtils.initWebView(mWebView);
    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        Preconditions.checkNotNull(message);
        ToastUtils.show(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        Preconditions.checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
//        getMenuInflater().inflate(R.Menu.menu_mTopBar_web_activity, Menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
//        if (id == android.R.id.home) {
//            finish();
//        } else if (id == R.id.action_share) {
//            DiycodeUtils.shareText(this, mWebView.getTitle(), mWebView.getUrl());
//        } else if (id == R.id.action_refresh) {
//            mWebView.reload();
//        } else if (id == R.id.action_open_browser) {
//            DiycodeUtils.openBrowser(this, mUrl);
//        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onBackPressed() {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
        } else {
            super.onBackPressed();
        }
    }

}
