package com.gingersoft.gsa.delivery_pick_mode.data.network.api

import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.*
import okhttp3.RequestBody
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Query

interface WeatherService {

    @POST("wechat/findOrderList")
    fun getOrderList(@Body requestBody: RequestBody): Call<OrderList>

    @POST("orderInfo/getOrderList")
    fun getNewOrderList(@Body requestBody: RequestBody): Call<OrderList>

    @POST("wx/updateRestOpenStatus")
    fun updateRestOpenStatus(@Body requestBody: RequestBody): Call<MessageBean>

    @POST("wechat/findOrderGroup")
    fun getOrderGroupNum(@Body requestBody: RequestBody): Call<OrderGoupNumBean>

    @POST("wechat/findOrderDetails")
    fun getOrderDesc(@Body requestBody: RequestBody): Call<OrderDetails>

    @POST("gsa/calculateEstimatedTime")
    fun getShipanyOrderTime(@Body requestBody: RequestBody): Call<EstimatedBean>

    @POST("wechat/updateOrderStatus")
    fun updateOrderStatus(@Body requestBody: RequestBody): Call<UpdateOrderBean>

    @POST("order/updateOrderStatus")
    fun gsUpdateOrderStatus(@Body requestBody: RequestBody): Call<MessageBean>

    @POST("order/updateOrderPay")
    fun updateOrderPay(@Body requestBody: RequestBody): Call<MessageBean>

    @POST("gsa/shipAnyOrdersNew")
    fun thirdDelivery(@Body requestBody: RequestBody): Call<ThirdSend>

    @POST("order/updateOrderInfoIsRead")
    fun updateIsRead(@Body requestBody: RequestBody): Call<String>

    @POST("wechat/updateSelfOrderStatus")
    fun updateSelfOrderStatus(@Body requestBody: RequestBody): Call<UpdateOrderBean>

    @POST("wechat/findRestDelivery")
    fun getDeliveryInfo(@Body requestBody: RequestBody): Call<DeliveryBean>

    @POST("gsa/getDeliveryConfigDTO")
    fun getDeliveryConfigDTO(@Body requestBody: RequestBody): Call<DeliveryConfig>

//    @POST("wechat/findHistoryOrderList")
//    fun getHistoryOrderList(@Body requestBody: RequestBody): Call<HistoryOrderBean>

    @GET("historyOrder/getOrderList")
    fun getHistoryOrderList(@Query("restaurantId") restaurantId: String,
                            @Query("startTime") startTime: String, @Query("endTime") endTime: String, @Query("param") param: String,
                            @Query("status") status: String, @Query("orderType") orderType: String, @Query("orderFrom") orderFrom: Int,@Query("pageIndex") pageIndex: String, @Query("pageSize") pageSize: String): Call<HistoryOrderBean>

    @POST("gsa/cancelOrder")
    fun cancelLogistics(@Body requestBody: RequestBody): Call<CancelLogisticsBean>

    @POST("order/updateOrderStatus")
    fun cancelOrder(@Body requestBody: RequestBody): Call<CancelLogisticsBean>

    @GET("restaurantFoodReason/config/list")
    fun getCancelReason(@Query("brandId") brandId: Int, @Query("restaurantId") restaurantId: Int, @Query("type") type: Int): Call<CancelReason>

    @GET("restaurant/pay/get")
    fun getPayMethod(@Query("brandId") brandId: Int, @Query("restaurantId") restaurantId: Int, @Query("payType") payType: Int): Call<PayTypeInfo>

    @POST("printerRecording/add")
    fun addPrj(@Body requestBody: RequestBody): Call<String>

    @GET("restaurantTransportationConfig/list")
    fun getTransportationConfig(@Query("restaurantId") restaurantId: String): Call<TransportationBean>

    @POST("logisticsExpensesAdditional/payment")
    fun additionalServiceCharge(@Body requestBody: RequestBody): Call<AddServiceChargeBean>

    @GET("balance/get")
    fun getBanlance(@Query("brandId") brandId: String): Call<BalanceBean>

    @GET("shipanyTransportAmount/get")
    fun getShipanyTransportAmount(@Query("orderId") orderId: String, @Query("uid") uid: String, @Query("restaurantId") restaurantId: String): Call<TransportAmountBean>

    @GET("logisticsExpensesAdditional/getAdditionalByOrderId")
    fun getAdditionalByOrderId(@Query("orderId") orderId: String, @Query("deletes") deletes: String): Call<ServiceChargeRecordBean>
}