package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.widget.Switch;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/28
 * Time: 11:54
 */
public class BooleanItemProvider extends FoodMenuItemProvider {

    @Override
    public int getItemViewType() {
        return FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_boolean;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, FoodMenuEditBean foodMenuEditBean) {
        super.convert(baseViewHolder, foodMenuEditBean);
        Switch sw = baseViewHolder.getView(R.id.switch_food_menu_item_state);
        sw.setChecked(foodMenuEditBean.isShowState());
        sw.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (foodMenuEditBean.isShowClient()) {
                FoodMenuAdapter adapter = (FoodMenuAdapter) getAdapter();
                if (adapter != null) {
                    if (isChecked) {
                        adapter.addClient();
                    } else {
                        adapter.removeClient();
                    }
                }
            }
        });
    }
}
