package com.joe.print.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.joe.print.di.module.PrinterAddModule;
import com.joe.print.mvp.contract.PrinterAddContract;

import com.jess.arms.di.scope.ActivityScope;
import com.joe.print.mvp.ui.activity.PrinterAddActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/16/2020 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = PrinterAddModule.class, dependencies = AppComponent.class)
public interface PrinterAddComponent {
    void inject(PrinterAddActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        PrinterAddComponent.Builder view(PrinterAddContract.View view);

        PrinterAddComponent.Builder appComponent(AppComponent appComponent);

        PrinterAddComponent build();
    }
}