package com.gingersoft.gsa.cloud.print.bean;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import lombok.Data;

/**
 * @author admin
 */
@Data
public class PrjBean implements Serializable {
    /**
     * prj狀態為不切紙
     */
    public static final int PRJ_STATUS_NOT_CUT_PAPER = 1;
    /**
     * prj狀態為切紙
     */
    public static final int PRJ_STATUS_CUT_PAPER = 2;
    /**
     * prj狀態為跟隨主項
     */
    public static final int PRJ_STATUS_FOLLOW_PARENT = 3;
    /**
     * id : 77
     * printerDeviceId : 1
     * status : 1
     * tableName : 51536
     * orderNo : gs201351936242891
     * orderTime : 2020
     * person : 2
     * orderDetailsTime : May 11, 2020 11:41:41 AM
     * orderDetailsId : 48828004
     * productName : 走青檸測試
     * parentId : 48827589
     * type : 4
     */
    private int id;
    private int printerDeviceId;
    private int status;//為2是帶*，需要切紙的
    public static final int PRJ_CUTE = 2;

    private String tableName;
    private String orderNo;
    private int orderTime;
    private int person;
    private String orderDetailsTime;
    private int orderDetailsId;
    private String productName;
    private String productName2;
    private String productName3;
    private int parentId;
    /**
     * 食品类型#3:食品;4:细项;
     */
    private int type;
    public static final int FOOD_TYPE = 3;
    public static final int FOOD_ITEM_TYPE = 4;

    /**
     * 打印狀態
     */
    private int printerType;
    private Long printerTime;
    private int number;
    private String productId;
    private Long createTime;

    private int requests;
    /**
     * 請求多少次開始飛單
     */
    public static final int REQUEST_COUNT_FLY = 5;

    private int actualPrinterDeviceId;
    private String takeFoodCode; //取餐碼
    private String billNo;//訂單碼
    /**
     * 訂單類型{@link com.gingersoft.gsa.cloud.common.constans.OrderTypeConstans}
     */
    private int orderType;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 服務員名稱
     */
    private String memberName;
    /***
     * 層級
     * 1:主食品
     * 2:子項or細項
     * 3:細項
     */
    private int itemType;
    public final static int FOOD_MAIN = 1;
    public final static int FOOD_SECONDARY = 2;
    public final static int FOOD_THREE_LEVEL = 3;

    private String sender;

    private String takeTime;
    private String sendTime;

    private int currentIndex;//當前是第幾張prj
    private int totalPrj;//本次總共有多少張prj
    private int isFirstSendOrder;//是否首次送單,1是 2否
    private int quantity;//統計打印數量
    private int presence;//presence：是否生成prj記錄 0：否，1：是
    public static final int NOT_GENERATED_PRJ = 0;
    public static final int GENERATED_PRJ = 1;

    private String printPosition;//廚房位置
    private String foodGroupName;//食品組
    private String flyingSinglePosition;//飛單位置
}
