package com.gingersoft.gsa.cloud.base.common.bean.discount;

import com.gingersoft.gsa.cloud.base.common.bean.BillOrderMoney;

import java.io.Serializable;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-22
 * 修订历史：2020-09-22
 * 描述：
 */
public class OrderDiscount {

    public static final int ORDER_DISCOUNT = 0;
    public static final int MEMBER_DISCOUNT = 1;
    public static final int COUPON_DISCOUNT = 2;

    @Data
    public static class Request {

        /**
         * 0#整單折扣
         * 1#會員折扣
         * 2#优惠券折扣
         */
        private int type;
        /**
         * 折扣ID
         */
        private Long discountId;
        /**
         * 會員折扣ID
         */
        private Long memberId;
        /**
         * 會員折扣比例
         */
        private Integer memberDiscountRate;
        /**
         * 折扣金額
         */
        private double discountAmount;
        /**
         * 是否计算服务费
         */
        private int scAble;

        public static Request orderDiscountTransRequest(BillOrderMoney discount) {
            Request request = new Request();
            request.setType(ORDER_DISCOUNT);
            if(discount.getDiscount() != null) {
                request.setDiscountId(discount.getDiscount().getId());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }


        public static Request memberDiscountTransRequest(BillOrderMoney discount) {
            Request request = new Request();
            request.setType(MEMBER_DISCOUNT);
            if(discount.getDiscount() != null) {
                request.setMemberId(discount.getDiscount().getId());
                request.setMemberDiscountRate((int) discount.getDiscount().getDiscount_value());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }

        public static Request couponDiscountTransRequest(BillOrderMoney discount) {
            Request request = new Request();
            request.setType(COUPON_DISCOUNT);
            if(discount.getDiscount() != null) {
                request.setMemberId(discount.getDiscount().getMemberId());
                request.setDiscountId(discount.getDiscount().getId());
                request.setMemberDiscountRate((int) discount.getDiscount().getDiscount_value());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }
    }

    @Data
    public static class Respose implements Serializable {

        /**
         * 整單折扣ID
         */
        private Long discountId;
        /**折扣金額*/
        private double discountAmount;
        /**折扣比例*/
        private int discountValue;
        /**
         * 0#整單折扣
         * 1#會員折扣
         * 2#优惠券折扣
         */
        private int type;
        /**折扣名称1*/
        private String remark;
        /**折扣名称2*/
        private String remark2;
        /**折扣名称3*/
        private String remark3;

        /**
         * 优惠券折扣相关
         */
        // 消費滿
        private Double spend;
        // 是否累計滿減：0否，1是
        private Byte accumulate;


        public String getRemark() {
            return remark;
        }


    }

}
