package com.joe.print.mvp.ui.adapter;

import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.mvp.model.bean.PrjBean;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created by Wyh on 2020/2/20.
 */
public class KitChenPrjPrintFoodAdapter extends BaseQuickAdapter<PrjBean.DataBean.Bean, BaseViewHolder> {

    private int indentation = 0;
    private PrinterDeviceBean printerDeviceBean;

    public KitChenPrjPrintFoodAdapter(@Nullable List<PrjBean.DataBean.Bean> data, PrinterDeviceBean printerDeviceBean) {
        super(R.layout.print_kitchen_item_parent, data);
        this.printerDeviceBean = printerDeviceBean;
    }

    @Override
    protected void convert(BaseViewHolder helper, PrjBean.DataBean.Bean item) {
        String[] languageTypes = printerDeviceBean.getLanguageType().split(",");
        LinearLayout layout = helper.getView(R.id.layout_print_kitchen_parent);
        for (String type : languageTypes) {

            String languageType = type;
            if (languageType.contains(".")) {
                languageType = type.substring(0, type.indexOf("."));
            }
            if (languageType.equals("2")) {
                //語言二
                layout.addView(getOtherLanguageView(helper.getAdapterPosition(), item.getItemType(), item.getProductName2(), item.getNumber()));
            } else if (languageType.equals("3")) {
                //語言三
                layout.addView(getOtherLanguageView(helper.getAdapterPosition(), item.getItemType(), item.getProductName3(), item.getNumber()));
            } else {
                //語言一或其他
                layout.addView(getOtherLanguageView(helper.getAdapterPosition(), item.getItemType(), item.getProductName(), item.getNumber()));
            }
        }
    }

    private View getOtherLanguageView(int adapterPosition, int itemType, String foodName, int foodNumber) {
        View view = View.inflate(getContext(), R.layout.print_kitchen_item_food, null);
        TextView tvFoodName = view.findViewById(R.id.tv_food_name);
        TextView tvFoodNum = view.findViewById(R.id.tv_food_number);
        if (adapterPosition == 0) {
            //只第一次測量一下
            indentation = new BigDecimal(tvFoodName.getPaint().measureText("哈")).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
        }

        int paddingLeft;
        if (itemType == 2) {
            //細項，縮進
            paddingLeft = indentation;
        } else if (itemType == 3) {
            //細項，縮進
            paddingLeft = indentation * 2;
        } else {
            paddingLeft = 0;
        }
        tvFoodName.setPadding(paddingLeft, tvFoodName.getPaddingTop(), tvFoodName.getPaddingRight(), tvFoodName.getPaddingBottom());
        tvFoodNum.setText(String.valueOf(foodNumber));
        tvFoodName.setText(foodName);
        return view;
    }
}
