package com.gingersoft.gsa.cloud.base.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.ui.view.ReloadView;

public abstract class BaseReloadView extends FrameLayout {

    private ReloadView.onReLoadListener onReLoadListener;

    private ReloadView reloadView;
    private ViewGroup contentView;
    private View replaceView;

    public void setOnReLoadListener(ReloadView.onReLoadListener onReLoadListener) {
        this.onReLoadListener = onReLoadListener;
        if(reloadView != null){
            reloadView.setOnReLoadListener(onReLoadListener);
        }
    }

    public BaseReloadView(@NonNull Context context) {
        this(context, null);
    }

    public BaseReloadView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public BaseReloadView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BaseReloadView init() {
        if (getDataIsNull()) {
            //如果不是打印，並且數據為空
            reloadView = new ReloadView(getContext());
            reloadView.setOnReLoadListener(onReLoadListener);
            getContentView();
            if (replaceView != null) {
                replaceView.setVisibility(GONE);
                ((ViewGroup)replaceView.getParent()).addView(reloadView);
            }
        } else {
            getContentView();
        }
        return this;
    }

    private ViewGroup getContentView() {
        if (contentView == null) {
            contentView = getChildView();
            addView(contentView);
            replaceView = contentView.findViewById(R.id.layout_replace);
        }
        return contentView;
    }

    public void notifyData() {
        if (getDataIsNull()) {
            //如果不是打印，並且數據為空
            if (reloadView == null) {
                reloadView = new ReloadView(getContext());
                reloadView.setOnReLoadListener(onReLoadListener);
                if (replaceView != null) {
                    replaceView.setVisibility(GONE);
                    ((ViewGroup)replaceView.getParent()).addView(reloadView);
                }
            } else {
                if (replaceView != null) {
                    replaceView.setVisibility(GONE);
                }
                if (reloadView != null) {
                    reloadView.setVisibility(VISIBLE);
                } else {
                    reloadView = new ReloadView(getContext());
                    reloadView.setOnReLoadListener(onReLoadListener);
                    ((ViewGroup)replaceView.getParent()).addView(reloadView);
                }
            }
        } else {
            if (reloadView != null) {
                reloadView.setVisibility(GONE);
            }
            if (replaceView != null) {
                replaceView.setVisibility(VISIBLE);
            }
            refreshData();
        }
    }

    public abstract boolean getDataIsNull();

    public abstract ViewGroup getChildView();

    public abstract void refreshData();
}
