package com.gingersoft.coldchain_module.mvp.model.service;

import com.gingersoft.coldchain_module.mvp.model.bean.BalanceBean;
import com.gingersoft.coldchain_module.mvp.model.bean.OrderList;
import com.gingersoft.coldchain_module.mvp.model.bean.PickUpBean;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementInfoBean;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementResultBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateRestaurantStateBean;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface ColdChainService {

    @Headers({"Domain-Name: ricepon_wechat"})
    @POST("wechat/findOrderList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<OrderList> getOrderList(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_order"})
    @POST("orderStatus/getNumByOrderType"  + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SupplementInfoBean> getNumByOrderType(@Body RequestBody requestBody);

    @Headers({"Domain-Name: update_version"})
    @POST("order/addOrder2" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SupplementResultBean> submitOrder(@Body RequestBody requestBody);


    @Headers({"Domain-Name: ricepon_gsa"})
    @POST("coldChain/pickUpShipany" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<PickUpBean> pickUp(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_wechat"})
    @POST("wechat/findHistoryOrderList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<String> getHistoryOrderList(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_activities"})
    @GET("balance/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BalanceBean> getBalance(@Query("brandId") String brandId);

    @Headers({"Domain-Name: member-web"})
    @POST("wx/updateRestOpenStatus" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<UpdateRestaurantStateBean> updateRestOpenStatus(@Body RequestBody requestBody);
}
