package com.gingersoft.gsa.cloud.manager.mvp.contract;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.table.TableItem;
import com.gingersoft.gsa.cloud.base.common.bean.table.TableArea;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/13/2020 14:47
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface TableManageContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

        void queryAreasSuccess(List<TableArea> areas, int type);

        void queryTablesSuccess(List<TableItem> tables, int type);

        void showEmptyView(boolean isSuccess, int size, Throwable t);

        void onStartRefreshTableData();

        void onPauseRefreshTableData();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        Observable<BaseResult> addArea(RequestBody requestBody);

        Observable<BaseResult> deleteArea(RequestBody requestBody);

        Observable<BaseResult> updateArea(RequestBody requestBody);

        Observable<BaseResult> queryAreas();

        Observable<BaseResult> addTable(RequestBody requestBody);

        Observable<BaseResult> deleteTable(RequestBody requestBody);

        Observable<BaseResult> updateTable(RequestBody requestBody);

        Observable<BaseResult> queryTables();

        Observable<BaseResult> changeAreaSort(RequestBody requestBody);

        Observable<BaseResult> changeTableSort(RequestBody requestBody);

        Observable<BaseResult> updateTableServiceCharge(RequestBody requestBody);
    }
}
