package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.table.TableBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManger.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManger.OpenTableManage;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.utils.DiscountDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseOrderRespose;
import com.gingersoft.gsa.cloud.table.mvp.contract.OrderContentContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableDetail;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MemberService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderPayService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.TableService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class OrderContentModel extends BaseModel implements OrderContentContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderContentModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    private void saveCreateTime(long createTime) {
        if (OpenTableManage.getDefault().getTableBean() == null) {
            OpenTableManage.getDefault().setTableBean(new TableBean.DataBean());
        }
        OpenTableManage.getDefault().getTableBean().setCreateTime(TimeUtils.getTime(createTime, TimeUtils.DEFAULT_DATE_FORMAT));
    }

    @Override
    public List<Discount> queryDB_DiscountList(String discountType) {
        DiscountDaoUtils discountDaoUtils = new DiscountDaoUtils(mApplication);
        return discountDaoUtils.queryDiscountByQueryBuilder();
    }

    @Override
    public Observable<BaseOrderRespose> loadOrder(long orderId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .loadOrder(orderId);
    }

    @Override
    public Observable<BaseOrderRespose> createOrder(RequestBody requestBody) {
        Observable ob = mRepositoryManager.obtainRetrofitService(MealService.class)
                .createOrder(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseOrderRespose>>() {
                    @Override
                    public Observable<BaseOrderRespose> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            saveCreateTime(info.getSysTime());
                            if (info.getData() != null) {
                                MyOrderManage.getInstance().setOrderId((Double) info.getData());
                            }
                            return loadOrder(MyOrderManage.getInstance().getOrderId());
                        }
                        return null;
                    }
                });
        return ob;
    }

    @Override
    public Observable<BaseOrderRespose> addFood(RequestBody requestBody) {
        Observable ob = mRepositoryManager.obtainRetrofitService(MealService.class)
                .addFood(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseOrderRespose>>() {
                    @Override
                    public Observable<BaseOrderRespose> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            saveCreateTime(info.getSysTime());
                            return loadOrder(MyOrderManage.getInstance().getOrderId());
                        }
                        return null;
                    }
                });
        return ob;
    }

    @Override
    public Observable<BaseOrderRespose> printOrder(RequestBody request) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .printOrder(request);
    }

    @Override
    public Observable<TableBean> getTables(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getTables(restaurantId);
    }

    @Override
    public Observable<TableDetail> getTable(int tableId, String tableNumber) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getTable(tableId, tableNumber);
    }

    @Override
    public Observable<BaseOrderRespose> transferFood(RequestBody requestBody) {
        Observable ob = mRepositoryManager.obtainRetrofitService(MealService.class)
                .transferFood(requestBody)
                .flatMap(new Function<BaseOrderRespose, Observable<BaseOrderRespose>>() {
                    @Override
                    public Observable<BaseOrderRespose> apply(BaseOrderRespose info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return loadOrder(MyOrderManage.getInstance().getOrderId());
                        }
                        return null;
                    }
                });
        return ob;
    }

    @Override
    public Observable<BaseResult> getSplitTables(int tableId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getSplitTables(tableId);
    }

    @Override
    public Observable<BaseResult> toOrderPay(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .toOrderPay(requestBody);
    }

    @Override
    public Observable<BaseResult> updateOrder(RequestBody formBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .updateOrder(formBody);
    }

    @Override
    public Observable<BaseResult> queryCoupon(int tableId,Long memberId, long couponMemberId, String couponNo, int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .queryCoupon(tableId,memberId, couponMemberId, couponNo, restaurantId);
    }

    @Override
    public Observable<BaseOrderRespose> calculationPrice(long orderId) {
        return null;
    }
}