package com.gingersoft.gsa.cloud.main.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.main.di.module.ReportModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.ReportContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.ReportActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/23/2020 16:18
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = ReportModule.class, dependencies = AppComponent.class)
public interface ReportComponent {
    void inject(ReportActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        ReportComponent.Builder view(ReportContract.View view);

        ReportComponent.Builder appComponent(AppComponent appComponent);

        ReportComponent build();
    }
}