package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.greendao.FunctionDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class FunctionDaoUtils {

    private static final String TAG = FunctionDaoUtils.class.getSimpleName();
    private DaoManager mManager;

    public FunctionDaoUtils(Context context){
        mManager = DaoManager.getInstance();
        mManager.init(context);
    }

    /**
     * 完成Function记录的插入，如果表未创建，先创建Function表
     * @param function
     * @return
     */
    public boolean insertFunction(Function function){
        boolean flag = false;
        flag = mManager.getDaoSession().getFunctionDao().insert(function) == -1 ? false : true;
        Log.i(TAG, "insert function :" + flag + "-->" + function.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     * @param functionList
     * @return
     */
    public boolean insertMultFunction(final List<Function> functionList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (Function Function : functionList) {
                        mManager.getDaoSession().insertOrReplace(Function);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     * @param function
     * @return
     */
    public boolean updateFunction(Function function){
        boolean flag = false;
        try {
            mManager.getDaoSession().update(function);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     * @param function
     * @return
     */
    public boolean deleteFunction(Function function){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(function);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     * @return
     */
    public boolean deleteAll(){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(Function.class);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     * @return
     */
    public List<Function> queryAllFunction(){
        return mManager.getDaoSession().loadAll(Function.class);
    }

    /**
     * 根据主键id查询记录
     * @param key
     * @return
     */
    public Function queryFunctionById(long key){
        return mManager.getDaoSession().load(Function.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<Function> queryFunctionByNativeSql(String sql, String[] conditions){
        return mManager.getDaoSession().queryRaw(Function.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询
     * @return
     */
    public List<Function> queryFunctionByQueryBuilder(long FunctionId){
        QueryBuilder<Function> queryBuilder = mManager.getDaoSession().queryBuilder(Function.class);
        return queryBuilder.where(FunctionDao.Properties.Id.eq(FunctionId)).list();
//        return queryBuilder.where(FunctionDao.Properties._id.ge(id)).list();
    }
}
