package com.gingersoft.gsa.cloud.ui.bean.view;

import com.qmuiteam.qmui.widget.section.QMUISection.Model;

import java.util.Objects;

/**
 * 單個文字
 */
public class SectionTextItem implements Model<SectionTextItem> {
    private int id;
    private String text;

    public SectionTextItem(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public SectionTextItem(String text) {
        this.text = text;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getText() {
        return text;
    }

    @Override
    public SectionTextItem cloneForDiff() {
        return new SectionTextItem(getText());
    }

    @Override
    public boolean isSameItem(SectionTextItem other) {
        return Objects.equals(text, other.text);
    }

    @Override
    public boolean isSameContent(SectionTextItem other) {
        return true;
    }
}
