package com.gingersoft.gsa.cloud.ui.bean.view;

import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-04
 * 修订历史：2020-03-04
 * 描述：
 */
public class SectionTextItem3 {

    private String leftText;
    private String centerText;
    private String rightText;

    public SectionTextItem3() {
    }

    public SectionTextItem3(String leftText, String centerText, String rightText) {
        this.leftText = leftText;
        this.centerText = centerText;
        this.rightText = rightText;
    }

    public String getLeftText() {
        return leftText;
    }

    public void setLeftText(String leftText) {
        this.leftText = leftText;
    }

    public String getCenterText() {
        return centerText;
    }

    public void setCenterText(String centerText) {
        this.centerText = centerText;
    }

    public String getRightText() {
        return rightText;
    }

    public void setRightText(String rightText) {
        this.rightText = rightText;
    }


    public static List<SectionTextItem3> orderDetailTransSectionTextItem3(List<OrderDetail> orderDetailList) {
        List<SectionTextItem3> sectionTextItem3List = new ArrayList<>();
        for (OrderDetail orderDetail : orderDetailList) {
            SectionTextItem3 sectionTextItem3 = new SectionTextItem3();
            String foodName;
            switch (orderDetail.getItemType()) {
                case 2:
                    foodName = "  " + orderDetail.getProductName();
                    break;
                case 3:
                    foodName = "      " + orderDetail.getProductName();
                    break;
                default:
                    foodName = orderDetail.getProductName();
                    break;
            }
            sectionTextItem3.setLeftText(foodName);
            sectionTextItem3.setCenterText(String.valueOf(orderDetail.getNumber()));
            sectionTextItem3.setRightText(String.valueOf(orderDetail.getPrice() * orderDetail.getNumber()));
            sectionTextItem3List.add(sectionTextItem3);
        }
        return sectionTextItem3List;
    }

    public static List<SectionTextItem3> orderPayMethodTransSectionTextItem3(List<PayMethod> payMethodList) {
        List<SectionTextItem3> sectionTextItem3List = new ArrayList<>();
        for (PayMethod payMethod : payMethodList) {
            SectionTextItem3 sectionTextItem3 = new SectionTextItem3();
            sectionTextItem3.setLeftText(payMethod.getPayName());
            sectionTextItem3.setCenterText(String.valueOf(0));
            sectionTextItem3.setRightText(String.valueOf(payMethod.getPayMoney()));
            sectionTextItem3List.add(sectionTextItem3);
        }
        return sectionTextItem3List;
    }

}
