package com.gingersoft.gsa.cloud.ui.widget.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.ColorDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gingersoft.gsa.cloud.base.R;


/**
 * description:弹窗浮动加载进度条
 * Created by xsf
 * on 2016.07.17:22
 */
public class LoadingDialog {
    /**
     * 加载数据对话框
     */
    private static Dialog mLoadingDialog;
    private static AnimationDrawable animationDrawable;
    private static TextView loadingText;

    /**
     * 显示加载对话框
     *
     * @param context    上下文
     * @param msg        对话框显示内容
     * @param cancelable 对话框是否可以取消
     */
    public static Dialog showDialogForLoading(Context context, String msg, boolean cancelable) {
        View view = LayoutInflater.from(context).inflate(R.layout.ui_dialog_loading, null);
        TextView loadingText = view.findViewById(R.id.tv_loading_dialog_text);
        loadingText.setText(msg);

        if (mLoadingDialog == null) {
            mLoadingDialog = new Dialog(context, R.style.ui_loading_dialog);
        }
        //不設置會有黑邊
        Window window = mLoadingDialog.getWindow();
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        window.getDecorView().setBackgroundResource(android.R.color.transparent);

        mLoadingDialog.setCancelable(cancelable);
        mLoadingDialog.setCanceledOnTouchOutside(false);
        mLoadingDialog.setContentView(view, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
        mLoadingDialog.show();
        return mLoadingDialog;
    }

    /**
     * 重新显示一個加载对话框，上面靜態的加載框，其他頁面的加載關閉了，會導致影響到當前頁面的加載框。
     *
     * @param context    上下文
     * @param msg        对话框显示内容
     * @param cancelable 对话框是否可以取消
     */
    public static Dialog showNewDialogForLoading(Context context, String msg, boolean cancelable) {
        View view = LayoutInflater.from(context).inflate(R.layout.ui_dialog_loading, null);
        loadingText = view.findViewById(R.id.tv_loading_dialog_text);
        loadingText.setText(msg);

        Dialog mLoadingDialog = new Dialog(context, R.style.ui_loading_dialog);
        mLoadingDialog.setCancelable(cancelable);
        mLoadingDialog.setCanceledOnTouchOutside(false);

        Window window = mLoadingDialog.getWindow();
        window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        window.getDecorView().setBackgroundResource(android.R.color.transparent);

        mLoadingDialog.setContentView(view, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
        mLoadingDialog.show();
        return mLoadingDialog;
    }

    public static Dialog showDialogForLoading(Activity context) {
        View view = LayoutInflater.from(context).inflate(R.layout.ui_dialog_loading, null);
        TextView loadingText = view.findViewById(R.id.tv_loading_dialog_text);
        loadingText.setText(context.getString(R.string.base_loading));

        if (mLoadingDialog == null) {
            mLoadingDialog = new Dialog(context, R.style.ui_loading_dialog);
        }
        mLoadingDialog.setCancelable(true);
        mLoadingDialog.setCanceledOnTouchOutside(false);
        mLoadingDialog.setContentView(view, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
        mLoadingDialog.show();
        return mLoadingDialog;
    }

    public static void setText(String msg) {
        if (loadingText != null) {
            loadingText.setText(msg);
        }
    }

    /**
     * 关闭加载对话框
     */
    public static void cancelDialogForLoading() {
        if (animationDrawable != null) {
            animationDrawable.stop();
            animationDrawable = null;
        }
        if (mLoadingDialog != null) {
            mLoadingDialog.dismiss();
            mLoadingDialog = null;
        }
        loadingText = null;
    }
}
