package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseRespose;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-06
 * 修订历史：2020-01-06
 * 描述：
 */
public interface MealService {

    @POST("order/send" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> createOrder(@Body RequestBody requestBody);

    @POST("orderDetails/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addFood(@Body RequestBody requestBody);

    @FormUrlEncoded
    @POST("order/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> loadOrder(@Field("orderId") long orderId);

    @POST("orderDetails/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteFood(@Body RequestBody requestBody);

//    @POST("behavior/print" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
//    Observable<BaseRespose> printOrder(@Body RequestBody requestBody);

    @POST("restaurantTable/print" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> printOrder(@Body RequestBody requestBody);

}
