package com.gingersoft.gsa.cloud.user.login.mvp.contract;

import android.content.Intent;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.base.utils.constans.UserConstans;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.ui.bean.mode.LoginBean;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem;
import com.gingersoft.gsa.cloud.ui.widget.dialog.ChooseRestaurantDialog;
import com.gingersoft.gsa.cloud.user.login.mvp.presenter.BaseLoginPresenter;
import com.gingersoft.gsa.cloud.user.login.mvp.ui.activity.SwitchServerActivity;
import com.jess.arms.base.BaseActivity;

import java.util.ArrayList;
import java.util.List;

public abstract class LoginInterfaceImpl<P extends BaseLoginPresenter> extends BaseActivity<P> implements BaseLoginContract.View {

    @Override
    public void loginSuccess(LoginBean info) {
        saveLoginInfo(info);
    }

    @Override
    public void startToSwitchServer() {
        startActivity(new Intent(mContext, SwitchServerActivity.class));
    }

    private void saveLoginInfo(LoginBean loginBean) {
        GsaCloudApplication.setBrandRestaurantInfos(mContext, "");
        if (loginBean.getData() != null) {
            GsaCloudApplication.setLoginToken(mContext, loginBean.getData().getToken());
            if (loginBean.getData().getUser() != null) {
                GsaCloudApplication.setMemberId(mContext, loginBean.getData().getUser().getUserId());
                GsaCloudApplication.setMemberName(mContext, loginBean.getData().getUser().getUserName());

                List<LoginBean.DataBean.UserBean.BrandsBean> brands = loginBean.getData().getUser().getBrands();
                if (brands != null) {
                    String brandRestaurantInfos = JsonUtils.toJson(brands);
                    GsaCloudApplication.setBrandRestaurantInfos(mContext, brandRestaurantInfos);
                }
                int restaurantSize = 0;
                List<LoginBean.DataBean.UserBean.BrandsBean> brandsBeans = new ArrayList<>();
                if (loginBean.getData().getUser().getBrands() != null) {
                    restaurantSize = getRestaurantSize(loginBean.getData().getUser().getBrands());
                    brandsBeans.addAll(loginBean.getData().getUser().getBrands());
                }

                boolean autoLogin = (boolean) SPUtils.get(mContext, UserConstans.AUTO_LOGIN, false);
                if (autoLogin) {
                    int restaurantId = GsaCloudApplication.getRestaurantId(this);
                    if (restaurantId != 0) {
                        //有選擇餐廳，直接跳轉首頁
                        jumpMainActivity();
                        return;
                    }
                }

                if (restaurantSize == 1) {
                    //只有一個品牌是直接進下載頁面
                    LoginBean.DataBean.UserBean.BrandsBean brandsBean = getOnlyBrand(loginBean.getData().getUser().getBrands());
                    LoginBean.DataBean.UserBean.BrandsBean.RestaurantsBean restaurantsBean = getOnlyRestaurant(loginBean.getData().getUser().getBrands());
                    if (brandsBean != null) {
                        saveBrandAndRestaurantInfo(brandsBean.getBrandId(), brandsBean.getBrandName(), restaurantsBean.getRestaurantId(), restaurantsBean.getRestaurantName());
                    }
                    jumpDownloadActivity();
                } else {
                    showChooseRestaurantDialog(brandsBeans, brands);
                }
            }
        }
    }

    protected void ChooseRestaurantItemClick(List<LoginBean.DataBean.UserBean.BrandsBean> brands, ChooseRestaurantDialog dialog, SectionTextItem item) {
        LoginBean.DataBean.UserBean.BrandsBean brandsBean = getBrandByRestaurantId(brands, item.getId());
        if (brandsBean != null) {
            saveBrandAndRestaurantInfo(brandsBean.getBrandId(), brandsBean.getBrandName(), item.getId(), item.getText());
        }
        dialog.dismiss();
        jumpDownloadActivity();
    }

    protected void saveBrandAndRestaurantInfo(int brandId, String brandName, int restaurantId, String restaurantName) {
        GsaCloudApplication.setBrandId(mContext, brandId);
        GsaCloudApplication.setBrandName(mContext, brandName);
        GsaCloudApplication.setRestaurantId(mContext, restaurantId);
        GsaCloudApplication.setRestaurantName(mContext, restaurantName);
    }

    private int getRestaurantSize(List<LoginBean.DataBean.UserBean.BrandsBean> brands) {
        int size = 0;
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null)
                size += brands.get(i).getRestaurants().size();
        }
        return size;
    }

    private LoginBean.DataBean.UserBean.BrandsBean getOnlyBrand(List<LoginBean.DataBean.UserBean.BrandsBean> brands) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    return brands.get(i);
                }
            }
        }
        return null;
    }

    private LoginBean.DataBean.UserBean.BrandsBean.RestaurantsBean getOnlyRestaurant(List<LoginBean.DataBean.UserBean.BrandsBean> brands) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    return brands.get(i).getRestaurants().get(j);
                }
            }
        }
        return null;
    }

    private LoginBean.DataBean.UserBean.BrandsBean getBrandByRestaurantId(List<LoginBean.DataBean.UserBean.BrandsBean> brands, int restaurantId) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    if (brands.get(i).getRestaurants().get(j).getRestaurantId() == restaurantId) {
                        return brands.get(i);
                    }
                }
            }
        }
        return null;
    }

    private void jumpDownloadActivity() {
        CC.obtainBuilder("Component.Download")
                .setActionName("showDownloadActivity")
                .build()
                .call();
        killMyself();
    }

    private void jumpMainActivity() {
        CC.obtainBuilder("Component.Main")
                .setActionName("showMainActivity")
                .build()
                .call();
        killMyself();
    }
}
