package com.gingersoft.gsa.cloud.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Discount;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "DISCOUNT".
*/
public class DiscountDao extends AbstractDao<Discount, Long> {

    public static final String TABLENAME = "DISCOUNT";

    /**
     * Properties of entity Discount.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Restaurant_id = new Property(1, int.class, "restaurant_id", false, "RESTAURANT_ID");
        public final static Property Amount = new Property(2, double.class, "amount", false, "AMOUNT");
        public final static Property Discount_value = new Property(3, double.class, "discount_value", false, "DISCOUNT_VALUE");
        public final static Property Type = new Property(4, int.class, "type", false, "TYPE");
        public final static Property DiscountType = new Property(5, String.class, "discountType", false, "DISCOUNT_TYPE");
        public final static Property Status = new Property(6, int.class, "status", false, "STATUS");
        public final static Property Remark = new Property(7, String.class, "remark", false, "REMARK");
        public final static Property Begin_time = new Property(8, String.class, "begin_time", false, "BEGIN_TIME");
        public final static Property End_time = new Property(9, String.class, "end_time", false, "END_TIME");
    }


    public DiscountDao(DaoConfig config) {
        super(config);
    }
    
    public DiscountDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"DISCOUNT\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 1: restaurant_id
                "\"AMOUNT\" REAL NOT NULL ," + // 2: amount
                "\"DISCOUNT_VALUE\" REAL NOT NULL ," + // 3: discount_value
                "\"TYPE\" INTEGER NOT NULL ," + // 4: type
                "\"DISCOUNT_TYPE\" TEXT," + // 5: discountType
                "\"STATUS\" INTEGER NOT NULL ," + // 6: status
                "\"REMARK\" TEXT," + // 7: remark
                "\"BEGIN_TIME\" TEXT," + // 8: begin_time
                "\"END_TIME\" TEXT);"); // 9: end_time
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"DISCOUNT\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Discount entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getRestaurant_id());
        stmt.bindDouble(3, entity.getAmount());
        stmt.bindDouble(4, entity.getDiscount_value());
        stmt.bindLong(5, entity.getType());
 
        String discountType = entity.getDiscountType();
        if (discountType != null) {
            stmt.bindString(6, discountType);
        }
        stmt.bindLong(7, entity.getStatus());
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(8, remark);
        }
 
        String begin_time = entity.getBegin_time();
        if (begin_time != null) {
            stmt.bindString(9, begin_time);
        }
 
        String end_time = entity.getEnd_time();
        if (end_time != null) {
            stmt.bindString(10, end_time);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Discount entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getRestaurant_id());
        stmt.bindDouble(3, entity.getAmount());
        stmt.bindDouble(4, entity.getDiscount_value());
        stmt.bindLong(5, entity.getType());
 
        String discountType = entity.getDiscountType();
        if (discountType != null) {
            stmt.bindString(6, discountType);
        }
        stmt.bindLong(7, entity.getStatus());
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(8, remark);
        }
 
        String begin_time = entity.getBegin_time();
        if (begin_time != null) {
            stmt.bindString(9, begin_time);
        }
 
        String end_time = entity.getEnd_time();
        if (end_time != null) {
            stmt.bindString(10, end_time);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Discount readEntity(Cursor cursor, int offset) {
        Discount entity = new Discount( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getInt(offset + 1), // restaurant_id
            cursor.getDouble(offset + 2), // amount
            cursor.getDouble(offset + 3), // discount_value
            cursor.getInt(offset + 4), // type
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // discountType
            cursor.getInt(offset + 6), // status
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // remark
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // begin_time
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9) // end_time
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Discount entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setRestaurant_id(cursor.getInt(offset + 1));
        entity.setAmount(cursor.getDouble(offset + 2));
        entity.setDiscount_value(cursor.getDouble(offset + 3));
        entity.setType(cursor.getInt(offset + 4));
        entity.setDiscountType(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setStatus(cursor.getInt(offset + 6));
        entity.setRemark(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setBegin_time(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setEnd_time(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Discount entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Discount entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Discount entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
