package com.gingersoft.gsa.cloud.base.table.bean;

import com.qmuiteam.qmui.widget.section.QMUISection;
import java.io.Serializable;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-05-20
 * 修订历史：2020-05-20
 * 描述：
 */
public class TableItem implements Serializable, QMUISection.Model<TableItem>{

    /**
     * id : 25839
     * tableName : ceshitai1*
     * restaurantId : 26
     * orderId : 21568
     * qrCode : d662883361ef0e815f12b7cf46763bba
     * seatCount : 99
     * createTime : Dec 28, 2019 3:37:41 PM
     * createBy : GSPOS
     * qrCodeImg : http://localhost/qrcode/tableQrcode-26-1663.jpg
     * posTableId : 1663
     * serviceCharge : 0
     * memberId : 0
     * status : 0
     * person : 2
     * useStatus: 0
     * sort : 0
     * regionId : 1
     */

    private long id;
    /**區域ID*/
    private int regionId;
    /**區域名稱*/
    private String regionName;
    private String tableName;
    private int restaurantId;
    private Long orderId;
    private String qrCode;
    /**默認就餐人數*/
    private int seatCount;
    /**最大就餐人數*/
    private int maxSeatCount;
    /**最小就餐人數*/
    private int minSeatCount;
    private String createTime;
    private String createBy;
    private String qrCodeImg;
    private int posTableId;
    private int serviceCharge;
    private int memberId;
    /**
     * 未開檯   0
     * 已開檯   1
     * 已送單   2
     * 已印单   3
     */
    private int status;
    /**
     * 用餐人數
     */
    private int person;
    /**
     * 使用狀態:
     *  未使用   0
     *  已使用   1
     */
    private int useStatus;
    /**
     * 排序
     */
    private int sort;
    /**
     0:堂食
     1:外賣
     2:自取
     */
    private int type = -1;

    public static  final  int TABLE_TYPE_CANTEEN = 0;
    public static  final  int TABLE_TYPE_TAKEAWAY = 1;
    public static  final  int TABLE_TYPE_SELF_FETCHING = 2;

    /**
     * 自定義字段
     */
    /**是否選中*/
    private boolean isChecked = false;

    /**
     * UI类型:
     *  餐台       0
     *  新增(+)   1
     */
    private int layoutType = 0;

    public TableItem() {
    }

    public TableItem(TableItem dataBean) {
        this.id = dataBean.id;
        this.regionId = dataBean.regionId;
        this.regionName = dataBean.regionName;
        this.tableName = dataBean.tableName;
        this.orderId = dataBean.orderId;
        this.restaurantId = dataBean.restaurantId;
        this.qrCode = dataBean.qrCode;
        this.seatCount = dataBean.seatCount;
        this.maxSeatCount = dataBean.maxSeatCount;
        this.minSeatCount = dataBean.minSeatCount;
        this.createTime = dataBean.createTime;
        this.createBy = dataBean.createBy;
        this.qrCodeImg = dataBean.qrCodeImg;
        this.posTableId = dataBean.posTableId;
        this.serviceCharge = dataBean.serviceCharge;
        this.memberId = dataBean.memberId;
        this.status = dataBean.status;
        this.person = dataBean.person;
        this.useStatus = dataBean.useStatus;
        this.sort = dataBean.sort;
        this.type = dataBean.type;
        this.isChecked = dataBean.isChecked;
    }

    public int getPerson() {
        return person;
    }

    public void setPerson(int person) {
        this.person = person;
    }

    public int getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(int useStatus) {
        this.useStatus = useStatus;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getRegionId() {
        return regionId;
    }

    public void setRegionId(int regionId) {
        this.regionId = regionId;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public int getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public int getSeatCount() {
        return seatCount;
    }

    public void setSeatCount(int seatCount) {
        this.seatCount = seatCount;
    }

    public int getMaxSeatCount() {
        return maxSeatCount;
    }

    public void setMaxSeatCount(int maxSeatCount) {
        this.maxSeatCount = maxSeatCount;
    }

    public int getMinSeatCount() {
        return minSeatCount;
    }

    public void setMinSeatCount(int minSeatCount) {
        this.minSeatCount = minSeatCount;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getQrCodeImg() {
        return qrCodeImg;
    }

    public void setQrCodeImg(String qrCodeImg) {
        this.qrCodeImg = qrCodeImg;
    }

    public int getPosTableId() {
        return posTableId;
    }

    public void setPosTableId(int posTableId) {
        this.posTableId = posTableId;
    }

    public int getServiceCharge() {
        return serviceCharge;
    }

    public void setServiceCharge(int serviceCharge) {
        this.serviceCharge = serviceCharge;
    }

    public int getMemberId() {
        return memberId;
    }

    public void setMemberId(int memberId) {
        this.memberId = memberId;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getSort() {
        return sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public boolean isChecked() {
        return isChecked;
    }

    public void setChecked(boolean checked) {
        isChecked = checked;
    }

    public int getLayoutType() {
        return layoutType;
    }

    public void setLayoutType(int layoutType) {
        this.layoutType = layoutType;
    }

    @Override
    public TableItem cloneForDiff() {
        return null;
    }

    @Override
    public boolean isSameItem(TableItem other) {
        return false;
    }

    @Override
    public boolean isSameContent(TableItem other) {
        return false;
    }

}
