package com.joe.print.mvp.print;

import android.graphics.Bitmap;

import com.gingersoft.gsa.cloud.print.PrintDataMaker;
import com.gingersoft.gsa.cloud.print.PrinterWriter;
import com.gingersoft.gsa.cloud.print.PrinterWriter80mm;
import com.joe.print.mvp.model.bean.PrintInfoBean;
import com.joe.print.mvp.print.utils.MyPrintUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 * ip打印類
 */
public class TestPrintMaker implements PrintDataMaker {

    private PrinterWriter printer;
    private List<PrintInfoBean> printInfoBeans;

    private Bitmap bitmap;
    private String ip;
    private int port;

    public TestPrintMaker(PrinterWriter printer, List<PrintInfoBean> printInfoBeans, String ip, int port) {
        this.printer = printer;
        this.printInfoBeans = printInfoBeans;
        this.ip = ip;
        this.port = port;
    }

    @Override
    public List<byte[]> getPrintData() {
        try {
            ArrayList<byte[]> data = new ArrayList<>();

            if (printer == null) {
                printer = new PrinterWriter80mm(255);
            }
            for (PrintInfoBean printInfoBean : printInfoBeans) {
                //如果打印多列內容，並且字體大小配置多個，則每一列取自己對應的字體大小
                for (int i = 0; i < printInfoBean.getContent().length; i++) {
                    print(printInfoBean, i);
                }
                printer.print("\n");
            }

//            data.add(ImageUtils.draw2PxPoint(bitmap));
            printer.printLineFeed();
            printer.printLineFeed();
            printer.feedPaperCutPartial();
            data.add(printer.getDataAndReset());
            data.add(printer.getDataAndClose());
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<>();
        }
    }

    @Override
    public String getPrjIds() {
        return null;
    }

    @Override
    public String getIp() {
        return ip;
    }

    @Override
    public int getPort() {
        return port;
    }

    private void print(PrintInfoBean printInfoBean, int i) throws IOException {
//        if (i == 0) {
//            location = 0;
//        }
        if (printInfoBean.getGravity() == 0) {
            printer.setAlignLeft();
        } else if (printInfoBean.getGravity() == 1) {
            printer.setAlignCenter();
        } else if (printInfoBean.getGravity() == 2) {
            printer.setAlignRight();
        }
        double textSize = (Double) MyPrintUtils.getContentByLength(printInfoBean.getSize(), i);

        //是否傾斜字體
        int isItalic = ((Boolean) MyPrintUtils.getContentByLength(printInfoBean.getIsItalic(), i)) ? 1 : 0;
        boolean isBold = (Boolean) MyPrintUtils.getContentByLength(printInfoBean.getIsBold(), i);
//        int color = (int) MyPrintUtils.getContentByLength(printInfoBean.getColor(), i);熱敏打印沒有顏色
        if (isBold) {
            printer.setEmphasizedOn();
        } else {
            printer.setEmphasizedOff();
        }
        printer.setFontSize(textSize);
        printer.print(printInfoBean.getContent()[i]);

//        mPrinter.addTextRotate(isItalic);
        //reverse取值0,1沒效果，ul下劃線，em加粗,
//        mPrinter.addLineSpace(100);//行間距
    }


}