package com.gingersoft.supply_chain.mvp.content;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;

import java.util.Map;

import lombok.NonNull;
import okhttp3.FormBody;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/5
 * Time: 16:27
 * Use:
 */
public class Constant {
    public static final int PAGE_SIZE = 10;
    public static final int PURCHASE_FOOD_MAX = 9999;
    /**
     * 庫存消耗——盤點消耗的id
     */
    public static final int INVENTORY_CONSUME_ID = 5;

    public static final int UPDATE = 2;
    public static final int DELETE = 1;
    public static final int NORMAL = 0;
    /**
     * 上傳圖片類型：食材圖
     */
    public static final int UPLOAD_PIC_TYPE_FOOD = 1;
    /**
     * 上傳圖片類型：訂單收貨圖
     */
    public static final int UPLOAD_PIC_TYPE_ORDER = 2;

    public static final String GET_INFO_ERROR = "數據獲取失敗，請稍候再試";
    public static final String INFO_SYNTAX_ERROR = "數據解析失敗，請聯繫開發人員";
    public static final String GET_INFO_LOADING = "數據獲取中...";
    public static final String QUERY_LOADING = "查詢中...";

    public static final String IMG_UPLOAD_LOADING = "圖片上傳中...";
    public static final String IMG_UPLOAD_FAIL = "圖片上傳失敗，請稍後重試";

    public static final String NULL_INFO_ERROR = "未獲取到數據，請退出後重試";
    public static final String SAVE_LOADING = "保存中...";
    public static final String SAVE_SUCCESS = "保存成功";
    public static final String SAVE_FAIL = "保存失敗，請稍後重試";
    public static final String UPDATE_LOADING = "修改中...";
    public static final String UPDATE_SUCCESS = "修改成功";
    public static final String UPDATE_FAIL = "修改失敗，請稍後重試";

    public static final String DELETE_LOADING = "刪除中...";
    public static final String DELETE_SUCCESS = "刪除成功";
    public static final String DELETE_FAIL = "刪除失敗，請稍後重試";

    public static void addBrandId(@NonNull Map<String, Object> map) {
        map.put("brandId", RestaurantInfoManager.newInstance().getBrandId());
    }

    public static void addRestaurantId(@NonNull Map<String, Object> map) {
        map.put("restaurantId", RestaurantInfoManager.newInstance().getRestaurantId());
    }

    public static void addBrandId(@NonNull FormBody.Builder builder) {
        builder.add("brandId", String.valueOf(RestaurantInfoManager.newInstance().getBrandId()));
    }

    public static void addRestaurantId(@NonNull FormBody.Builder builder) {
        builder.add("restaurantId", String.valueOf(RestaurantInfoManager.newInstance().getRestaurantId()));
    }

    public static void addPageSize(Map<String, Object> map) {
        map.put("pageSize", PAGE_SIZE);
    }

}
