package com.gingersoft.gsa.delivery_pick_mode.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.gingersoft.gsa.delivery_pick_mode.R;
import com.gingersoft.gsa.delivery_pick_mode.R2;
import com.gingersoft.gsa.delivery_pick_mode.di.component.DaggerSendOrderComponent;
import com.gingersoft.gsa.delivery_pick_mode.mvp.contract.SendOrderContract;
import com.gingersoft.gsa.delivery_pick_mode.mvp.presenter.SendOrderPresenter;
import com.gingersoft.gsa.delivery_pick_mode.ui.adapter.DeliveryAdapter;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.Arrays;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;

/**
 * @author admin
 */
public class SendOrderActivity extends BaseActivity<SendOrderPresenter> implements SendOrderContract.View, View.OnClickListener {

    @BindView(R2.id.send_order_top_bar)
    QMUITopBar topBar;
    @BindView(R2.id.rv_send_order_foods)
    RecyclerView rvSendOrderFoods;
    @BindView(R2.id.rv_send_order_bills)
    RecyclerView rvSendOrderBills;
    @BindView(R2.id.tv_send_order_name_text)
    TextView tvSendOrderNameText;
    @BindView(R2.id.ed_send_order_name)
    EditText edSendOrderName;
    @BindView(R2.id.iv_select_member_arrow)
    ImageView ivSelectMemberArrow;
    @BindView(R2.id.tv_send_order_phone_text)
    TextView tvSendOrderPhoneText;
    @BindView(R2.id.ed_send_order_phone)
    EditText edSendOrderPhone;
    @BindView(R2.id.tv_send_order_address_text)
    TextView tvSendOrderAddressText;
    @BindView(R2.id.ed_send_order_address)
    EditText edSendOrderAddress;
    @BindView(R2.id.iv_select_address_arrow)
    ImageView ivSelectAddressArrow;
    @BindView(R2.id.tv_send_order_label_text)
    TextView tvSendOrderLabelText;
    @BindView(R2.id.rv_send_order_label)
    RecyclerView rvSendOrderLabel;
    @BindView(R2.id.tv_send_order_distribution_mode_text)
    TextView tvSendOrderDistributionModeText;
    @BindView(R2.id.rv_send_order_distribution_mode)
    RecyclerView rvSendOrderDistributionMode;
    @BindView(R2.id.tv_send_order_pay_mode_text)
    TextView tvSendOrderPayModeText;
    @BindView(R2.id.rv_send_order_pay_mode)
    RecyclerView rvSendOrderPayMode;
    @BindView(R2.id.tv_send_order_delivery_time_text)
    TextView tvSendOrderDeliveryTimeText;
    @BindView(R2.id.tv_delivery_time_type)
    TextView tvDeliveryTimeType;
    @BindView(R2.id.tv_continue_add_food)
    TextView tvContinueAddFood;
    @BindView(R2.id.tv_confirm_order)
    TextView tvConfirmOrder;

    private List<String> labelStrings = Arrays.asList("家", "公司", "學校", "醫院");
    private List<String> distributionModes = Arrays.asList("本店配送", "物流配送");
    private List<String> payTypes = Arrays.asList("貨到付款", "立即支付");

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSendOrderComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.other_order_activity_send_order;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mPresenter.getConfirmTakeawayOrderData();

        DeliveryAdapter deliveryAdapter = new DeliveryAdapter(labelStrings);
        rvSendOrderLabel.setLayoutManager(new GridLayoutManager(mContext, 4));
        rvSendOrderLabel.setAdapter(deliveryAdapter);

        rvSendOrderDistributionMode.setLayoutManager(new GridLayoutManager(mContext, 3));
        rvSendOrderDistributionMode.setAdapter(new DeliveryAdapter(distributionModes));

        rvSendOrderPayMode.setLayoutManager(new GridLayoutManager(mContext, 3));
        rvSendOrderPayMode.setAdapter(new DeliveryAdapter(payTypes));
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topBar.setTitle("送單信息");
        topBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        topBar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> killMyself());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @OnClick()
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        switch (viewId){
        }
    }

}
