package com.gingersoft.gsa.cloud.bean.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.bean.di.module.TableModule;
import com.gingersoft.gsa.cloud.bean.mvp.contract.TableContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.gsa.cloud.bean.mvp.ui.activity.TableActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = TableModule.class, dependencies = AppComponent.class)
public interface TableComponent {
    void inject(TableActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        TableComponent.Builder view(TableContract.View view);

        TableComponent.Builder appComponent(AppComponent appComponent);

        TableComponent build();
    }
}