package com.gingersoft.gsa.cloud.bean.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.bean.R;
import com.gingersoft.gsa.cloud.bean.R2;
import com.gingersoft.gsa.cloud.bean.di.component.DaggerTableComponent;
import com.gingersoft.gsa.cloud.bean.mvp.contract.TableContract;
import com.gingersoft.gsa.cloud.bean.mvp.model.bean.event.InitTableEvent;
import com.gingersoft.gsa.cloud.bean.mvp.model.constant.TableActionConstant;
import com.gingersoft.gsa.cloud.bean.mvp.model.table.action.TableAction;
import com.gingersoft.gsa.cloud.bean.mvp.presenter.TablePresenter;
import com.gingersoft.gsa.cloud.bean.mvp.ui.fragment.AllTableFragment;
import com.gingersoft.gsa.cloud.bean.mvp.ui.fragment.InputTableFragment;
import com.gingersoft.gsa.cloud.constans.GoldConstants;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.arch.QMUIFragmentPagerAdapter;
import com.qmuiteam.qmui.layout.QMUIButton;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.popup.QMUIPopup;
import com.qmuiteam.qmui.widget.popup.QMUIPopups;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.scwang.smartrefresh.layout.api.RefreshLayout;

import org.simple.eventbus.Subscriber;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class TableActivity extends BaseFragmentActivity<TablePresenter> implements TableContract.View {

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.tabSegment)
    QMUITabSegment mTabSegment;
    @BindView(R2.id.contentViewPager)
    ViewPager mContentViewPager;
    @BindView(R2.id.tv_show_popup)
    TextView tv_show_popup;

    @BindView(R2.id.rv_bottom_function)
    RecyclerView rv_bottom_function;
    @BindView(R2.id.btn_cancel_operat)
    QMUIButton btn_cancel_operat;

    @BindView(R2.id.ll_table_operat_content)
    LinearLayout ll_table_operat_content;
    @BindView(R2.id.tv_table_action_hint)
    TextView tv_table_action_hint;
    @BindView(R2.id.tv_table_action_content)
    TextView tv_table_action_content;

    @BindView(R2.id.iv_tab_icon)
    ImageView iv_tab_icon;

    /**
     * 輪訓刷新餐檯數據
     */
    public static boolean isRefreshData = true;

    public static final int FUNCTION_ALL_TABLE = 1;
    public static final int FUNCTION_STATE_TABLE = 2;

    private InputTableFragment inputTableFragment;
    private AllTableFragment allTableFragment, stateTableFragment;

    private String[] mTabTitles = {"編號", "全部", "狀態:全部"};
    /**
     * 切換餐檯狀態下拉框
     */
    private QMUIPopup mTableStatusPopup;
    /**
     * 當前顯示頁下標
     */
    private int mCurrentPageIndex = 1;
    /**
     * 當前所顯示餐檯狀態（默認：全部）
     */
    private int mCurrentSelectTableStatus = TableActionConstant.table_status_0;


    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.table_activity_table; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        tv_show_popup.setWidth(ArmsUtils.getScreenWidth(this) / 3);

        initTabAndPager();
        getTables(true, null);
    }

    @Subscriber(tag = "initTable_status_event")
    private void notifyUpdateTableStatus(InitTableEvent tableEvent) {
        mPresenter.initTable(tableEvent.getTableId(), tableEvent.getTableNumber(), false);
        canceTableAction();
    }


    @Override
    protected void onRestart() {
        super.onRestart();
        mPresenter.initBottomFunction();
        //開始刷新餐檯數據
        onStartRefreshTableData();
    }

    @Override
    protected void onStart() {
        super.onStart();
        mPresenter.initBottomFunction();
        //開始刷新餐檯數據
        onStartRefreshTableData();
    }

    @Override
    protected void onPause() {
        super.onPause();
        //停止刷新餐檯數據
        onPauseRefreshTableData();
    }

    @Override
    public void initIntent() {
    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        mTopBar.removeAllLeftViews();
        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                killMyself();
            }
        });
        QMUIAlphaImageButton rightButton = mTopBar.addRightImageButton(R.drawable.icon_refresh, R.id.btn_right);
        QMUIAlphaImageButton rightButton2 = mTopBar.addRightImageButton(R.mipmap.meal_down, R.id.btn_fid);
        rightButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                getTables(true, null);
            }
        });
        rightButton2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                CC.obtainBuilder("Component.Download")
                        .setActionName("showDownloadActivity")
                        .addParam("fromPage", 2)
                        .build()
                        .call();
            }
        });
        mTopBar.setTitle("餐檯模式");
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(TableActivity.this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        if (intent != null) {
            ArmsUtils.startActivity(intent);
        }
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void returnTableList(List<TableBean.DataBean> dataBeanList) {
        if (dataBeanList != null && dataBeanList.size() > 0) {
            mPresenter.filterTableByAction();
        }
    }

    @Override
    public void returnSplitTableList(List<TableBean.DataBean> dataBeanList) {

    }

    @Override
    public AllTableFragment getCurrentTableFragment() {
        switch (mCurrentPageIndex) {
            case FUNCTION_STATE_TABLE:
                return stateTableFragment;
            default:
                return allTableFragment;
        }
    }

    @Override
    public void clickTableItem(TableBean.DataBean dataBean) {
        if (dataBean == null) {
            return;
        }
        boolean doAction = mPresenter.doTableAction(dataBean);
        if (!doAction) {
            if (dataBean.getSplitStatus() == 1) {
                mPresenter.showSplitTableDialog(dataBean.getId());
            } else {
                mPresenter.openTable(dataBean.getId(), null);
            }
        }
    }

    @OnClick({R2.id.btn_cancel_operat})
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btn_cancel_operat) {
            canceTableAction();
        }
    }

    @Override
    public void setCurrentTableAction(TableAction action) {
        btn_cancel_operat.setVisibility(View.VISIBLE);
        ll_table_operat_content.setVisibility(View.VISIBLE);
        rv_bottom_function.setVisibility(View.INVISIBLE);
        setTableActionTitle(action);
    }

    @Override
    public void setTableActionTitle(TableAction action) {
        mTopBar.setTitle(action.getActionTitle());
        tv_table_action_hint.setText(action.getActionHint());
        tv_table_action_content.setText(action.getActionContent());
        //移除back鍵
        mTopBar.removeAllLeftViews();
    }

    @Override
    public void canceTableAction() {
        btn_cancel_operat.setVisibility(View.INVISIBLE);
        ll_table_operat_content.setVisibility(View.INVISIBLE);
        rv_bottom_function.setVisibility(View.VISIBLE);

        tv_table_action_hint.setText("");
        tv_table_action_content.setText("");
        mTopBar.setTitle("餐檯模式");
        //添加back鍵
        mTopBar.removeAllLeftViews();
        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                killMyself();
            }
        });
        mPresenter.initTableActionParameter();
        mPresenter.filterTableByAction();
    }

    @Override
    public void startMealStandActivity() {
        startActivity(new Intent(this, MealStandActivity.class));
    }

    @Override
    public void setTableActionContentText(String contentText) {
        tv_table_action_content.setText(contentText);
    }

    @Override
    public String getOperatContentText() {
        return tv_table_action_content.getText().toString();
    }

    @Override
    public void onStartRefreshTableData() {
        isRefreshData = true;
        mPresenter.startTableTimer();
        getTables(false, null);
    }

    @Override
    public void onPauseRefreshTableData() {
        isRefreshData = false;
        mPresenter.cancelTableTimer();
        //立刻停止獲取餐檯接口
        if (mPresenter.getGetTablesDataDisposable() != null && !mPresenter.getGetTablesDataDisposable().isDisposed()) {
            mPresenter.getGetTablesDataDisposable().dispose();
        }
    }

    @Override
    public void setBottomFunctionAdapter(DefaultAdapter adapter) {
        setBottomFunctionRecycleLayoutManager(LinearLayoutManager.VERTICAL);
        rv_bottom_function.setAdapter(adapter);
    }

    @Override
    public void setBottomFunctionRecycleLayoutManager(int orientation) {
        GridLayoutManager bottomFunctionRecycleLayoutManager = new GridLayoutManager(this, GoldConstants.bottomFunctionColCount, orientation, false);
        rv_bottom_function.setLayoutManager(bottomFunctionRecycleLayoutManager);
        rv_bottom_function.setItemAnimator(new DefaultItemAnimator());
    }

    @Override
    public void setBottomFunctionVisibility(boolean show) {
        rv_bottom_function.setVisibility(show == true ? View.VISIBLE : View.GONE);
    }

    private void initTabAndPager() {
        QMUIFragmentPagerAdapter pagerAdapter = new QMUIFragmentPagerAdapter(getSupportFragmentManager()) {
            @Override
            public Fragment createFragment(int position) {
                Bundle bundle = new Bundle();
                switch (position) {
                    case 1:
                        if (allTableFragment != null) {
                            return allTableFragment;
                        }
                        allTableFragment = AllTableFragment.newInstance();
                        bundle.putInt("currentPageIndex", FUNCTION_ALL_TABLE);
                        allTableFragment.setArguments(bundle);
                        return allTableFragment;
                    case 2:
                        if (stateTableFragment != null) {
                            return stateTableFragment;
                        }
                        stateTableFragment = AllTableFragment.newInstance();
                        bundle.putInt("currentPageIndex", FUNCTION_STATE_TABLE);
                        stateTableFragment.setArguments(bundle);
                        return stateTableFragment;
                    default:
                        if (inputTableFragment != null) {
                            return inputTableFragment;
                        }
                        inputTableFragment = InputTableFragment.newInstance();
                        return inputTableFragment;
                }
            }

            @Override
            public int getCount() {
                return mTabTitles.length;
            }

            @Override
            public CharSequence getPageTitle(int position) {
                return "";
            }
        };
        QMUITabBuilder builder = mTabSegment.tabBuilder();
        QMUITab tab1 = builder
                .setText(mTabTitles[0])
                .build(mContext);
        QMUITab tab2 = builder
                .setText(mTabTitles[1])
                .build(mContext);
        QMUITab tab3 = builder
                .setNormalDrawable(ContextCompat.getDrawable(mContext, R.drawable.arrow_down_black))
                .setSelectedDrawable(ContextCompat.getDrawable(mContext, R.drawable.arrow_down_black))
                .setIconPosition(QMUITab.ICON_POSITION_RIGHT)
                .setText(mTabTitles[2])
                .build(mContext);
        mTabSegment
                .addTab(tab1)
                .addTab(tab2)
                .addTab(tab3);

        mContentViewPager.setAdapter(pagerAdapter);
        mContentViewPager.setCurrentItem(mCurrentPageIndex);
        int space = QMUIDisplayHelper.dp2px(this, 16);
        mTabSegment.setIndicator(new QMUITabIndicator(QMUIDisplayHelper.dp2px(this, 2), false, true));
        mTabSegment.setDefaultTextSize(QMUIDisplayHelper.dp2px(this, 16), QMUIDisplayHelper.dp2px(this, 16));
        mTabSegment.setPadding(space, 0, space, 0);
        mTabSegment.setupWithViewPager(mContentViewPager, false);
        mTabSegment.setOnTabClickListener(new QMUITabSegment.OnTabClickListener() {
            @Override
            public void onTabClick(int index) {
                //彈出選擇狀態彈窗
                if (mCurrentPageIndex == 2 && index == 2) {
                    showTableStatusListPopup(tv_show_popup);
                }
                mCurrentPageIndex = index;
            }
        });
        mTabSegment.addOnTabSelectedListener(new QMUITabSegment.OnTabSelectedListener() {

            @Override
            public void onTabSelected(int index) {
                switch (index) {
                    case 0:
                        //setBottomFunctionVisibility(false);
                        //标号输入页面 暂停刷新餐台数据
//                        onPauseRefreshTableData();
                        break;
                    case 1:
                    case 2:
//                    setBottomFunctionVisibility(true);
                        //页面切换完成区域，状态页面恢复获取餐台数据
//                        onStartRefreshTableData();
                        break;
                }
                mCurrentPageIndex = index;
            }

            @Override
            public void onTabUnselected(int index) {
                //滑動過程中先 暫停刷新數據
//                onPauseRefreshTableData();
            }

            @Override
            public void onTabReselected(int index) {
                LogUtil.d(TAG, "onTabReselected " + index);
            }

            @Override
            public void onDoubleTap(int index) {
                LogUtil.d(TAG, "onDoubleTap " + index);
            }
        });
    }

    private void showTableStatusListPopup(View view) {
        List<Map<String, Object>> lists = new ArrayList<>();
        String[] statusTextList = new String[]{
                "全部",
                "可使用",
                "已使用",
                "已開檯",
                "已印單",
                "已分檯",
        };
        int[] statusIconList = new int[]{
                R.drawable.table_shape_status_all,
                R.drawable.table_shape_status_be_usable,
                R.drawable.table_shape_status_used,
                R.drawable.table_shape_status_send,
                R.drawable.table_shape_status_print,
                R.drawable.table_shape_status_split,
        };
        for (int i = 0; i < statusTextList.length; i++) {
            Map<String, Object> map = new HashMap<>();
            map.put("text", statusTextList[i]);
            map.put("image", statusIconList[i]);
            lists.add(map);
        }
        SimpleAdapter adapter = new SimpleAdapter(this, lists, R.layout.table_item_popup_select_table_status
                , new String[]{"text", "image"}
                , new int[]{R.id.tv_status, R.id.iv_status});
        mTableStatusPopup = QMUIPopups.listPopup(this, QMUIDisplayHelper.getScreenWidth(this) / 3, QMUIDisplayHelper.getScreenHeight(this), adapter, new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                mTableStatusPopup.dismiss();
                mTabSegment.updateTabText(2, "狀態:" + statusTextList[position]);
                //根据选择的餐台操作状态 显示相应的台号
                filterTableByTableStatus(position);
            }
        }).dimAmount(0.6f).show(view);
    }

    /**
     * 根据餐台状态 过滤餐台
     */
    public void filterTableByTableStatus(int status) {
        this.mCurrentSelectTableStatus = status;
        nofilyFragmentUpdateTableData(mPresenter.getTableList());
    }

    /**
     * 更新相應頁面餐檯數據
     *
     * @param dataBeanList
     */
    public void nofilyFragmentUpdateTableData(List<TableBean.DataBean> dataBeanList) {
        Message message = Message.obtain();
        message.what = 1;
        message.obj = dataBeanList;
        message.arg1 = mCurrentSelectTableStatus;
        if (inputTableFragment != null) {
            inputTableFragment.setData(message);
        }
        if (allTableFragment != null) {
            allTableFragment.setData(message);
        }
        if (stateTableFragment != null) {
            stateTableFragment.setData(message);
        }
    }

    public void getTables(boolean show, RefreshLayout refreshLayout) {
        mPresenter.getTables(show, refreshLayout);
    }

    public int getCurrentSelectTableStatus() {
        return mCurrentSelectTableStatus;
    }

    public void setCurrentSelectTableStatus(int mCurrentSelectTableStatus) {
        this.mCurrentSelectTableStatus = mCurrentSelectTableStatus;
    }


}
