package com.gingersoft.gsa.delivery_pick_mode.ui.activity

import android.os.Bundle
import androidx.core.content.ContextCompat
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.DeliveryConfig
import com.gingersoft.gsa.delivery_pick_mode.ui.base.BaseActivity
import com.gingersoft.gsa.delivery_pick_mode.ui.fragment.DeliveryFragment
import com.gingersoft.gsa.delivery_pick_mode.ui.fragment.UpdateDeliveryFragment
import kotlinx.android.synthetic.main.activity_delivery.*

class DeliverySettingActivity : BaseActivity() {

    lateinit var deliverylist_fragment: DeliveryFragment

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_delivery)
        deliverylist_fragment = supportFragmentManager.findFragmentById(R.id.deliverylist_fragment) as DeliveryFragment

        top_bar_delivery.setTitle("配送設置")
        top_bar_delivery.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color))
        top_bar_delivery.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener { finish() }
        top_bar_delivery.addRightImageButton(R.drawable.ic_add, R.id.topbar_right_change_button).setOnClickListener {
            supportFragmentManager.beginTransaction().add(R.id.fl_delivery, UpdateDeliveryFragment.newInstance(null)).addToBackStack(null).commit()
        }
    }

    fun editDelivery(info: DeliveryConfig.Data.DeliveryInfo?) {
        supportFragmentManager.beginTransaction().add(R.id.fl_delivery, UpdateDeliveryFragment.newInstance(info)).addToBackStack(null).commit()
    }
}