package com.gingersoft.gsa.cloud.bean.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.bean.mvp.model.service.OrderService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.bean.mvp.contract.OrderCenterContract;

import io.reactivex.Observable;
import io.reactivex.functions.Function;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/13/2020 14:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class OrderCenterModel extends BaseModel implements OrderCenterContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderCenterModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> loadOrderList(int restaurantId,String orderType, int pageIndex, int pageSize) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .loadOrderList(restaurantId, orderType,pageIndex, pageSize);
    }

    @Override
    public Observable<BaseResult> cancelOrder(long orderId, int restaurantId,String orderType) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .cancelOrder(orderId)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return loadOrderList(restaurantId, orderType,0, 10);
                        }
                        return Observable.just(info);
                    }
                });
    }

}