package com.gingersoft.gsa.cloud.pay;

import android.content.Context;

import com.gingersoft.gsa.cloud.pay.pos.PosPayAction;
import com.gingersoft.gsa.cloud.pay.pos.bean.BaseBgRequest;
import com.gingersoft.gsa.cloud.pay.pos.bean.BasePosRequest;
import com.gingersoft.gsa.cloud.pay.pos.yedpay.YedpayCallback;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.Preconditions;

import lombok.Builder;
import lombok.Getter;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:32
 * @更新時間: 2020-12-26 10:32
 * @描述:
 */
@Builder
@Getter
public final class PosPay {

    final Context context;
    final IView lifecycleView;
    final int payType;
    final BasePosRequest posRequest;
    final BaseBgRequest bgRequest;
    final PayAction retrievalAction;
    final Callback callback;
    final boolean showLoading;
    final long orderId;
    final String txnId;

    //yedpay所需
    final double payMoney;
    final YedpayCallback yedpayCallback;

    public void pay() {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(null);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.pay(this);
    }

    public void tip() {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(null);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.tip(this);
    }

    public void refund() {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(null);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.refund(this);
    }

    public void voidO() {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(null);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.void0(this);
    }

    public void retrieval() {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(null);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.retrieval(this);
    }

    public void printStub() {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(null);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.printStub(this);
    }

    public void settlement() {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(null);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.settlement(this);
    }
}
