package com.gingersoft.gsa.cloud.main.mvp.ui.view;


import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;

import com.daivd.chart.data.BarData;
import com.daivd.chart.data.LineData;
import com.daivd.chart.provider.component.mark.IMark;

/**
 * Created by huang on 2017/9/28.
 */

public class CustomMarkView<C extends BarData> implements IMark<C> {
    private Paint paint;
    private int mTodayColor = Color.parseColor("#018EF2");
    private int mYesterDayColor = Color.parseColor("#FFCC8F");
    private LineData columnData;
    private LineData columnData2;

    public CustomMarkView(LineData columnData) {
        this.columnData = columnData;
        initPaint();
    }

    public CustomMarkView(LineData columnData, LineData columnData2) {
        this.columnData = columnData;
        this.columnData2 = columnData2;
        initPaint();
    }

    private void initPaint() {
        paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextSize(34);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(Color.parseColor("#333333"));
    }

    public CustomMarkView setTodayColor() {
        return this;
    }

    public Paint getPaint() {
        return paint;
    }

    public int getTextHeight() {
        Paint.FontMetrics fontMetrics = getPaint().getFontMetrics();
        return (int) (fontMetrics.bottom - fontMetrics.top);
    }


    public int getTextWidth(String content) {
        return (int) getPaint().measureText(content);
    }

    private int verticalPadding = 15;
    private int horizontalPadding = 15;
    private int contentInterval = 7;//內容空隙
    private int ovalWidth = 23;//圓點的寬度

    @Override
    public void drawMark(Canvas canvas, float x, float y, Rect rect, String content, BarData d, int position) {
        float rectWidth = 0;//矩形寬度
        float rectHeight = 0;//矩形高度
        int row = 0;
        float textHeight = getTextHeight();
        String content1 = null, content2 = null;
        if (columnData != null && columnData.getName() != null && position <= columnData.getChartYDataList().size()) {
            content1 = columnData.getName() + columnData.getChartYDataList().get(position);
        }
        if (columnData2 != null && columnData2.getChartYDataList() != null && position <= columnData2.getChartYDataList().size()) {
            content2 = columnData2.getName() + columnData2.getChartYDataList().get(position);
        }
        if (content != null) {
            row++;
            rectWidth = Math.max(rectWidth, getTextWidth(content));
        }
        if (content1 != null) {
            row++;
            rectWidth = Math.max(rectWidth, getTextWidth(content1));
        }
        if (content2 != null) {
            row++;
            rectWidth = Math.max(rectWidth, getTextWidth(content2));
        }
        //矩形寬度=圓點寬度+圓點與內容的間距+左右間距
        rectWidth += ovalWidth + contentInterval + horizontalPadding * 2;
        //矩形高度=三行文字的高度+三行文字中間是兩行間距+上下間距
        rectHeight = getTextHeight() * row + contentInterval * 2 + verticalPadding * 2;
        float selfWidth = rectWidth / 2;
        float selfHeight = rectHeight / 2;

        RectF rectf = new RectF(x - selfWidth, y - selfHeight, x + selfWidth, y + selfHeight);
        //判斷在有效範圍內
        if (x > rect.left && x < rect.right) {
            if (rectf.left < rect.left) {
                rectf.left = rect.left;
                rectf.right = rect.left + rectWidth;
            }
            if (rectf.right > rect.right) {
                rectf.right = rect.right;
                rectf.left = rect.right - rectWidth;
            }
        }
        //設置陰影
        paint.setShadowLayer(10, 0, 0, Color.parseColor("#33000000"));  //第一个参数是阴影扩散半径，紧接着的2个参数是阴影在X和Y方向的偏移量，最后一个参数是颜色
        paint.setColor(Color.parseColor("#FFFFFF"));
        canvas.drawRoundRect(rectf, 8, 8, paint);
        //清除陰影
        paint.clearShadowLayer();
        //繪製時間
        paint.setColor(Color.parseColor("#333333"));
        if (content != null) {
            canvas.drawText(content, rectf.left + horizontalPadding + ovalWidth + contentInterval, rectf.top + verticalPadding + textHeight, paint);
        }
        float ovalHeight = (textHeight - ovalWidth) / 2;//圓和文字上下空隙，為了居中顯示
        if (content2 != null) {
            canvas.drawText(content2, rectf.left + horizontalPadding + ovalWidth + contentInterval, rectf.top + verticalPadding + contentInterval + textHeight * 2, paint);
            paint.setColor(columnData2.getLineStyle().getColor());
            RectF yesterDayOvalRect = new RectF(rectf.left + horizontalPadding, rectf.top + verticalPadding + contentInterval + textHeight + ovalWidth - ovalHeight, rectf.left + horizontalPadding + ovalWidth, rectf.top + verticalPadding + contentInterval + textHeight + ovalWidth * 2 - ovalHeight);
            canvas.drawOval(yesterDayOvalRect, paint);
        }
        if (content1 != null) {
            paint.setColor(Color.parseColor("#333333"));
            canvas.drawText(content1, rectf.left + horizontalPadding + ovalWidth + contentInterval, rectf.top + verticalPadding + contentInterval * 2 + textHeight * row, paint);
            paint.setColor(columnData.getLineStyle().getColor());
            RectF yesterDayOvalRect = new RectF(rectf.left + horizontalPadding, rectf.top + verticalPadding + contentInterval * 2 + (textHeight * (row - 1)) + ovalWidth - ovalHeight, rectf.left + horizontalPadding + ovalWidth, rectf.top + verticalPadding + contentInterval * 2 + (textHeight * (row - 1)) + ovalWidth * 2 - ovalHeight);
            canvas.drawOval(yesterDayOvalRect, paint);
        }
    }
}
