package com.gingersoft.gsa.cloud.base.utils;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.utils.constans.UserConstans;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019-12-29
 * 修订历史：2019-12-29
 * 描述：
 */
public class UserDataUtils {



    //获取登陆token
    public static String getLoginToken(Context context) {
        return (String) SPUtils.get(context, UserConstans.token, "0");
    }

    public static String getMemberId(Context context) {
        return (String) SPUtils.get(context, UserConstans.memberId, "0");
    }

    public static String getRestaurantId(Context context) {
        return (String) SPUtils.get(context, UserConstans.restaurantId, "");
    }

    public static void setMemberId(Context context, int memberId) {
        SPUtils.put(context, UserConstans.memberId, memberId);
    }

    public static void setLoginToken(Context context, String token) {
        SPUtils.put(context, UserConstans.token, token);
    }

    public static void setRestaurantId(Context context, int restaurantId) {
        SPUtils.put(context, UserConstans.restaurantId, restaurantId);
    }

}
