package com.gingersoft.gsa.cloud.account.user.state;

import android.app.Activity;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.account.user.UserContext;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.component.ComponentName;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:未登錄狀態
 */
public class LogoutState implements UserState {


    @Override
    public void logined() {
        //跳轉登錄頁面
        CC.obtainBuilder(ComponentName.COMPONENT_LOGIN)
                .setActionName("showActivityA")
                .build()
                .call();
    }

    @Override
    public void logOut() {

        UserContext.newInstance().removeUserInfo();

        //关闭Prj打印服務
        CC.obtainBuilder(ComponentName.COMPONENT_PRINT)
                .setActionName("stopPrintService")
                .build()
                .call();

        Activity activity = GsaCloudApplication.getAppContext().getCurrentActivity();
        if (activity != null) {
            String name = activity.getClass().getSimpleName();
            if (!name.equals("LoginActivity")) {
                //跳轉登陸頁面
                CC.obtainBuilder(ComponentName.COMPONENT_LOGIN)
                        .setActionName("showActivityA")
                        .build()
                        .call();
            }
        }
    }


}
