package com.gingersoft.gsa.cloud.function;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:標識所在頁面的RecycleView,GridView等功能組數據源，如NewMainActivity頁面下有多個RecycleView *  * 每個RecycleView就是一個{@link XFunctionItems}}
 * 如：
 * @XFunctionViews(FunctionMain.ORDER_GROUP) private List<Function> mOrderingMeals;
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface XFunctionViews {

    String value();

    /**
     * 過濾父級，一般為功能組名
     * @return
     */
    boolean filterParent() default true;
}
