package com.gingersoft.gsa.cloud.main.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SendSettlement;
import com.gingersoft.gsa.cloud.main.mvp.model.service.SettlementService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;
import javax.inject.Inject;

import com.gingersoft.gsa.cloud.main.mvp.contract.SettlementReportContract;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/04/2020 21:36
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class SettlementReportModel extends BaseModel implements SettlementReportContract.Model{
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public SettlementReportModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<SendSettlement> sendSettlement(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(SettlementService.class)
                .sendSettlement(requestBody);
    }

    @Override
    public Observable<BaseResult> getSettlementReport(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(SettlementService.class)
                .getSettlementReport(restaurantId);
    }
}