package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.ui.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.ui.loadsir.ErrorCallback;
import com.gingersoft.gsa.cloud.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerSupplierListComponent;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;
import com.gingersoft.supply_chain.mvp.contract.SupplierListContract;
import com.gingersoft.supply_chain.mvp.presenter.SupplierListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.SupplierAdapter;
import com.jess.arms.di.component.AppComponent;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadSir;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * ================================================
 * Description: 供應商列表
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 17:41
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class SupplierListFragment extends BaseSupplyChainFragment<SupplierListPresenter> implements SupplierListContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_supplier_list)
    QMUITopBar mTopBarSupplierList;
    @BindView(R2.id.rv_supplier_list)
    RecyclerView rvSupplierList;
    @BindView(R2.id.btn_new_supplier)
    QMUIAlphaButton btnNewSupplier;
    @BindView(R2.id.ed_supplier_search)
    EditText edSupplier;
    public final static int SUPPLIER_LIST = 101;
    private SupplierAdapter supplierAdapter;
    @BindView(R2.id.srl_supplier)
    SmartRefreshLayout smartRefreshLayout;

    private int pageIndex = 0;

    public static SupplierListFragment newInstance() {
        SupplierListFragment fragment = new SupplierListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerSupplierListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_supplier_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        loadService = LoadSir.getDefault().register(smartRefreshLayout, (Callback.OnReloadListener) v -> {
            // 重新加载逻辑
            pageIndex = 0;
            getSupplierList("");
        });
        initTopBar();
        getSupplierList("");

        smartRefreshLayout.setOnRefreshListener(refreshLayout -> {
            pageIndex = 0;
            getSupplierList("");
        });
        smartRefreshLayout.setOnLoadMoreListener(refreshLayout -> {
            pageIndex++;
            getSupplierList("");
        });
    }

    private void getSupplierList(String content) {
        mPresenter.getSupplierList(content, pageIndex);
    }

    private void initTopBar() {
        mTopBarSupplierList.setTitle("供應商");
        mTopBarSupplierList.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBarSupplierList.addRightImageButton(R.drawable.ic_screen, R.id.topbar_right_screen_button).setOnClickListener(this);
    }

    @OnClick({R2.id.btn_new_supplier, R2.id.btn_supplier_search})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_right_screen_button) {
            //篩選
        } else if (viewId == R.id.btn_new_supplier) {
            //新增供應商
            startForResult(NewSupplierFragment.newInstance(null), SUPPLIER_LIST);
        } else if (viewId == R.id.btn_supplier_search) {
            getSupplierList(edSupplier.getText() + "");
        }
    }

    @Override
    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (requestCode == SUPPLIER_LIST) {
            //新增或編輯了供應商，重新獲取所有供應商數據
            getSupplierList("");
        }
    }

    @Override
    public void loadSupplierList(List<SupplierInfoBean> supplierBeanList) {
        smartRefreshLayout.finishRefresh();
        smartRefreshLayout.finishLoadMore();
        if (supplierBeanList.size() == 0) {
            loadService.showCallback(EmptyCallback.class);
            smartRefreshLayout.setEnableLoadMore(false);
            return;
        } else {
            loadService.showSuccess();
            smartRefreshLayout.setEnableLoadMore(true);
        }
        if (supplierAdapter == null) {
            supplierAdapter = new SupplierAdapter(supplierBeanList);
            rvSupplierList.setAdapter(supplierAdapter);

            supplierAdapter.setOnItemClickListener((adapter, view, position) -> {
                List<SupplierInfoBean> data = supplierAdapter.getData();
                startForResult(NewSupplierFragment.newInstance(data.get(position)), SUPPLIER_LIST);
            });
            supplierAdapter.setOnItemChildClickListener((adapter, view, position) -> {
                if (view.getId() == R.id.iv_supplier_delete) {
                    new AppDialog().showWaringDialog(mContext, "刪除供應商", (view1, dialog) -> {
                        dialog.dismiss();
                        List<SupplierInfoBean> data = supplierAdapter.getData();
                        mPresenter.deleteSupplier(data.get(position), position);
                    });
                }
            });
        } else {
            supplierAdapter.setList(supplierBeanList);
        }
    }

    @Override
    public void deleteSuccess(int position) {
        supplierAdapter.removeAt(position);
        if (supplierAdapter.getData().size() == 0) {
            loadService.showCallback(EmptyCallback.class);
        }
    }

    @Override
    public void loadError() {
        loadService.showCallback(ErrorCallback.class);
    }
}
