package com.gingersoft.gsa.cloud.table;

import com.gingersoft.gsa.cloud.function.FModule;
import com.gingersoft.gsa.cloud.function.XFunctionItems;

/**
 * @author : bin
 * @create date: 2020-11-27
 * @update date: 2020-11-27
 * @description:
 */
public class FunctionTable {

    public static final String TABLE_GROUP = "table";
    public static final String TABLE_BOTTOM_GROUP = TABLE_GROUP + "/bottom/";
    public static final String MANAGER_GROUP = TABLE_GROUP + "/manager/";
    public static final String ORDER_GROUP = TABLE_GROUP + "/order/";

    /**
     * 餐檯頁
     */
    @XFunctionItems(TABLE_BOTTOM_GROUP)
    public static final FModule[] bottom = {
            new FModule(TABLE_BOTTOM_GROUP + "init", R.mipmap.table_init, 0),
            new FModule(TABLE_BOTTOM_GROUP + "initSkyorder", R.mipmap.table_paper, 0),
            new FModule(TABLE_BOTTOM_GROUP + "move", R.mipmap.table_move, 0),
            new FModule(TABLE_BOTTOM_GROUP + "skyorder", 0, 0),
            new FModule(TABLE_BOTTOM_GROUP + "splite", R.mipmap.table_splite, 0),
            new FModule(TABLE_BOTTOM_GROUP + "parper", R.mipmap.table_paper, 0),
    };
    /**
     * 餐牌頁
     */
    @XFunctionItems(MANAGER_GROUP)
    public static final FModule[] meal = {
            new FModule(MANAGER_GROUP + "plu", R.mipmap.table_paper, 0),
            new FModule(MANAGER_GROUP + "discount", R.mipmap.table_skyorder, 0)
    };
    /**
     * 賬單內容頁
     */
    @XFunctionItems(ORDER_GROUP)
    public static final FModule[] order = {
            new FModule(ORDER_GROUP + "send", 0, 0),
            new FModule(ORDER_GROUP + "print", 0, 0),
            new FModule(ORDER_GROUP + "pay", 0, 0),
            new FModule(ORDER_GROUP + "transfer", 0, 0),
            new FModule(ORDER_GROUP + "discount", 0, 0)
    };
}
