package com.gingersoft.gsa.cloud.print.bean.adapter;

import android.text.TextUtils;
import com.gingersoft.gsa.cloud.account.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.gingersoft.gsa.cloud.print.bean.PrintContent;
import com.gingersoft.gsa.cloud.print.bean.PrintTakeawayFormContent;
import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintPayTypeItem;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-01
 * @update date: 2020-12-01
 * @description:
 */
@Data
public class PrintContentAdapter implements AdaptationContent {


    public PrintContentAdapter() {
    }

    @Override
    public PrintContent adaptationQRCode() {
        return null;
    }

    @Override
    public PrintContent adaptationPrintTakeawayFormContent(OrderDetails.DataBean data) {
        return getPrintTakeawayFormContent(data);
    }

    @Override
    public PrintContent adaptationPrintTakeawayCheckoutContent(OrderDetails.DataBean data) {
        return getPrintTakeawayFormContent(data);
    }

    @Override
    public PrintContent adaptationPrintCleanMachineContent() {
        return null;
    }

    public PrintTakeawayFormContent getPrintTakeawayFormContent(OrderDetails.DataBean data) {
        PrintTakeawayFormContent takeawayFormContent = new PrintTakeawayFormContent();
        takeawayFormContent.setBrand(ResturantInfoManager.newInstance().getBrandName());
        takeawayFormContent.setResturantName(ResturantInfoManager.newInstance().getRestaurantName());
        takeawayFormContent.setPayType(String.valueOf(data.getPayType()));
        takeawayFormContent.setDeliveryTime(data.getOrder_type() == 2 ? data.getSEND_TIME() : data.getTakeTime());
        takeawayFormContent.setOrderNumber(data.getORDER_NO());
        takeawayFormContent.setBillNumber(data.getBillNo());
        takeawayFormContent.setOrderTakeFoodCode(data.getTakeFoodCode());
        takeawayFormContent.setBillingTime(data.getCREATE_TIME());
        takeawayFormContent.setPayTime(data.getPayTime());
        takeawayFormContent.setRemark(data.getRemark());
//        takeawayFormContent.setFoodItemList(getPrintFoodItemsByProductBeans(data.getPRODUCT_NAME()));
        takeawayFormContent.setBillItemList(getBillItemListByInfo(data.getTOTAL_AMOUNT(), data.getLunchbox(), data.getDELIVERY_CHARGE()));
        takeawayFormContent.setPrintPayTypeItemList(getPrintPayTypeItemsByPayMultiple(data.getPayMultiple()));
        takeawayFormContent.setTotalAmountText("總金額: ");
        takeawayFormContent.setTotalAmount(data.getTOTAL_AMOUNT());
        takeawayFormContent.setPayAmountText("支付金額: ");
        takeawayFormContent.setPayAmount(String.valueOf(data.getPAY_AMOUNT()));
        takeawayFormContent.setMemberName(data.getMEMBER_NAME());
//        takeawayFormContent.setMemberNumber(data.getm);
        takeawayFormContent.setMemberPhone(data.getPHONE());
        takeawayFormContent.setMemberOldPoints(String.valueOf(data.getOldPoints()));
        takeawayFormContent.setMemberAddPoints(String.valueOf(data.getAddPoints()));
        takeawayFormContent.setMemberNowPoints(String.valueOf(data.getNowPoints()));
        takeawayFormContent.setAdress(data.getAddressDetail());
        takeawayFormContent.setReceiver(data.getRECEIVER());
        takeawayFormContent.setPhone(data.getPHONE());
        takeawayFormContent.setPoliteLanguage("謝謝光臨!");
        return takeawayFormContent;
    }


//    private List<PrintFoodItem> getPrintFoodItemsByProductBeans(List<OrderDetails.DataBean.PRODUCTNAMEBean> productnameBeanList) {
//        List<OrderDetail> orderDetailList = OrderDetail.productMameBeanToOrderDetail(1, productnameBeanList);
//        List<PrintFoodItem> printFoodItems = new ArrayList<>();
//        for (OrderDetail orderDetail : orderDetailList) {
//            printFoodItems.add(new PrintFoodItem(orderDetail.getProductName(), orderDetail.getNumber(), orderDetail.getPrice(), orderDetail.getItemType()));
//        }
//        return printFoodItems;
//    }

    private List<PrintBillItem> getBillItemListByInfo(String totalAmount, double lunchbox, double deliveryCharge) {
        List<PrintBillItem> billItems = new ArrayList<>();
        if (TextUtils.isEmpty(totalAmount)) {
            billItems.add(new PrintBillItem("合計: ", String.valueOf(totalAmount)));
        }
        if (lunchbox != 0.0) {
            billItems.add(new PrintBillItem("餐盒費: ", String.valueOf(lunchbox)));
        }
        if (deliveryCharge != 0.0) {
            billItems.add(new PrintBillItem("送貨費: ", String.valueOf(deliveryCharge)));
        }
        return billItems;
    }

    private List<PrintPayTypeItem> getPrintPayTypeItemsByPayMultiple(List<OrderDetails.DataBean.PayMultiple> payMultiples) {
        List<PrintPayTypeItem> printPayTypeItems = new ArrayList<>();
        for (OrderDetails.DataBean.PayMultiple payMultiple : payMultiples) {
            printPayTypeItems.add(new PrintPayTypeItem(payMultiple.getPayName(), String.valueOf(payMultiple.getAmount())));
        }
        return printPayTypeItems;
    }
}
