package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.gingersoft.gsa.cloud.base.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.base.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 結賬單  已改新版
 */
public class PrintBill extends PrinterRoot {


    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {

        DoshokuOrder doshokuOrder = DoshokuOrder.getInstance();
        ShoppingCart shoppingCart = doshokuOrder.getShoppingCart();

        List<OrderDetail> foodList = shoppingCart.getOrderCommodityList();
        TableBean.DataBean tableBean = doshokuOrder.getOpenTableInfo();

        StringBuilder payInfo = new StringBuilder();
        for (PayMethod payMethod : doshokuOrder.getBillMoney()) {
            payInfo.append(payMethod.getPayName() + " ").append(payMethod.getPayMoney());
        }

        StringBuilder memberIntegerInfo = new StringBuilder();
        OrderDetails.DataBean data = getOrderMemberInfo();
        if (data.getAddPoints() != 0 || data.getOldPoints() != 0 || data.getAddPoints() != 0) {
            memberIntegerInfo.append(getPLable("本次積分：" + data.getAddPoints(), HTML_PRINT_GRAVITY_LEFT))
                    .append(getPLable("結餘積分：" + data.getNowPoints(), HTML_PRINT_GRAVITY_LEFT))
                    .append(getPLable("上次積分：" + data.getOldPoints(), HTML_PRINT_GRAVITY_LEFT));
            //名稱中間替換為*號
            if (data.getMEMBER_NAME() != null && data.getMEMBER_NAME().length() > 0) {
                memberIntegerInfo.append(getPLable("會員名稱：" + getReplaceAfter(data.getMEMBER_NAME()), HTML_PRINT_GRAVITY_LEFT));
            }
            if (data.getPHONE() != null && data.getPHONE().length() > 0) {
                memberIntegerInfo.append(getPLable("會員電話：" + getReplaceAfter(data.getPHONE()), HTML_PRINT_GRAVITY_LEFT));
            }
        }

        String stringBuilder = "<html><body>" +
                getHtmlPrintHeadInfo() +
                getHtmlPrintHeadOrderInfo(tableBean) +
                generateHtmlFoodInfo(foodList) +
                getHtmlBillInfo() +
                getWholeLine() +
                getPLable(payInfo.toString(), HTML_PRINT_GRAVITY_LEFT) +
                getWholeLine() +
                getPLable(memberIntegerInfo.toString(), HTML_PRINT_GRAVITY_LEFT);

        String integralQrCode = doshokuOrder.getIntegralQrcode();
        if (!TextUtils.isEmpty(integralQrCode) &&
                (boolean) RestaurantExpandInfoUtils.getValue(ExpandConstant.ToPrintQRCode, false)) {
            stringBuilder += getPLable("請掃描二維碼", HTML_PRINT_GRAVITY_CENTER) +
                    getHtmlQrCode(doshokuOrder.getIntegralQrcode()) +
                    getPLable("《追加積分到個人賬戶》", HTML_PRINT_GRAVITY_CENTER);
        }
        stringBuilder += "</body></html>";
        String[] pritContent = new String[1];
        pritContent[0] = stringBuilder;
        return pritContent;
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.TableModeClosingPC, 1);
    }

    private Bitmap getBitmap(Context mContext, PrinterDeviceBean deviceBean) {

        DoshokuOrder doshokuOrder = DoshokuOrder.getInstance();
        ShoppingCart shoppingCart = doshokuOrder.getShoppingCart();


        List<OrderDetail> foodList = shoppingCart.getOrderCommodityList();
        TableBean.DataBean tableBean = doshokuOrder.getOpenTableInfo();

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));

        //訂單信息
        String tableName = "餐檯：" + tableBean.getTableName();
        String peopleNum = "人數：" + doshokuOrder.getOpenTableInfo().getPerson();
        String orderNum = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(doshokuOrder.getOrderNo())) {
            orderNum = "單號：" + doshokuOrder.getOrderNo();
        }
        String createTime = "日期：" + TimeUtils.parseTimeRepeat(tableBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT);
        layout.addView(getDiningTableOrderInfo(mContext, tableName, peopleNum, orderNum, createTime));
        layout.addView(getLine(mContext));

        //食品信息
        layout.addView(getDiningFoodList(mContext, foodList, deviceBean, 1, true));
        layout.addView(getHalfLine(mContext));

        //訂單金額信息
        List<BillingBean> billingBeans = new ArrayList<>();
        //添加合計項
        billingBeans.add(new BillingBean("合計", shoppingCart.getWholeAmount()));
        //添加其他金額項
        if (shoppingCart.getBillItemList().size() > 0) {
            for (BillItem item : shoppingCart.getBillItemList()) {
                billingBeans.add(new BillingBean(item.getName(), item.getMoney()));
            }
        }
        layout.addView(getDiningBillInfo(mContext, billingBeans));


        layout.addView(getHalfLine(mContext));

//        BigDecimal totalAmount = new BigDecimal(0);
//        for (OrderDetail OrderDetail : MyOrderManage.getInstance().getOrderFoodList()) {
//            totalAmount = MoneyUtil.sum(totalAmount, OrderDetail.getPrice());
//        }
        layout.addView(getAmountText(mContext, "總金額：" + shoppingCart.getTotalAmount()));
        layout.addView(getLine(mContext));
        layout.addView(getDiningBillPayMethod(mContext, doshokuOrder.getBillMoney()));
        layout.addView(getLine(mContext));

        layout.addView(getTableMealMemberIntegerView(mContext, getOrderMemberInfo(), doshokuOrder.getIntegralQrcode()));

        return zoomBitmap(deviceBean, viewToBitmap(mContext, layout));
    }


    private OrderDetails.DataBean getOrderMemberInfo() {
        OrderDetails.DataBean dataBean = new OrderDetails.DataBean();
        MemberInfo memberInfo = DoshokuOrder.getInstance().getMemberInfo();
        if (memberInfo != null) {
            dataBean.setMEMBER_NAME(memberInfo.getMemberName());
            dataBean.setPHONE(memberInfo.getPhone());
            dataBean.setNowPoints(DoshokuOrder.getInstance().getNowPoints());
            dataBean.setAddPoints(DoshokuOrder.getInstance().getAddPoints());
            dataBean.setOldPoints(DoshokuOrder.getInstance().getOldPoints());
        }
        return dataBean;
    }

}
