package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;

import com.gingersoft.gsa.cloud.account.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.account.user.UserContext;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.PrintTransitUtils;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.bean.SettlementReport;
import com.gingersoft.gsa.cloud.constans.AppConstans;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.PrintCleanMachineContent;
import com.joe.print.mvp.model.bean.HtmlLable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.joe.print.mvp.print.common.HtmlContract.ATTRIBUTES_ALIGN;
import static com.joe.print.mvp.print.common.HtmlContract.ATTRIBUTES_OFFSET;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_COLUMN;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_P;
import static com.joe.print.mvp.print.common.HtmlContract.value_align_center;
import static com.joe.print.mvp.print.common.HtmlContract.value_offset_last;
import static com.joe.print.mvp.print.common.HtmlContract.value_offset_percentage20;
import static com.joe.print.mvp.print.common.HtmlContract.value_offset_percentage30;
import static com.joe.print.mvp.print.common.HtmlContract.value_offset_percentage50;
import static com.joe.print.mvp.print.common.HtmlContract.value_offset_percentage60;
import static com.joe.print.mvp.print.common.HtmlContract.value_offset_percentage70;

/**
 * 清機打印
 */
public class PrintCleanMachine extends PrinterRoot<PrintCleanMachineContent> {

    private PrintCleanMachineContent mCleanMachineContent;
    private Map<String, SettlementReport.AnalysisBean> mAnalysisBeanMap = null;

    @Override
    protected void setPrintContent(PrintCleanMachineContent printContent) {
        this.mCleanMachineContent = printContent;
        this.mAnalysisBeanMap = getAnalysisBeanMap(mCleanMachineContent.getAnalysis());
    }

    private Map<String, SettlementReport.AnalysisBean> getAnalysisBeanMap(List<SettlementReport.AnalysisBean> analysisBeanList) {
        Map<String, SettlementReport.AnalysisBean> analysisBeanMap = new HashMap<>();
        for (int i = 0; i < analysisBeanList.size(); i++) {
            analysisBeanMap.put(analysisBeanList.get(i).getTypeName(), analysisBeanList.get(i));
        }
        return analysisBeanMap;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getServeBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {
        if (mCleanMachineContent == null) {
            return new String[]{"<html><body></body></html>"};
        }
        String stringBuilder = "<html><body>" +
                getHtmlHeadInfo() +
                getHtmlBusinessTotal() +
                getHtmlCashDetails() +
                getHtmlAnalysisAndStatistics() +
                getHtmlBillingStatisticsItems() +
                getHtmlBillStatusItems() +
                getHtmlCumulativeThisMonth() +
                getHtmlEndInfo()
                + "</body></html>";
        String[] pritContent = new String[1];
        pritContent[0] = stringBuilder;
        return pritContent;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }

    /**
     * 獲取"清機報表"圖片
     *
     * @param mContext
     * @return
     */
    private Bitmap getServeBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        View view = PrintTransitUtils.getInstance().getPrintView();
        if (view != null) {
            return viewToZoomBitmap(mContext, view, deviceBean);
        }
        return null;
    }

    private String getHtmlHeadInfo() {
        List<HtmlLable> htmlLables = new ArrayList<>();
        htmlLables.add(new HtmlLable(LABLE_P, "上次清機時間:" + mCleanMachineContent.getRestaurantOperation().getOperationTime()));
        htmlLables.add(new HtmlLable(LABLE_P, "品牌名稱:" + ResturantInfoManager.newInstance().getBrandName()));
        htmlLables.add(new HtmlLable(LABLE_P, "店鋪名稱:" + ResturantInfoManager.newInstance().getRestaurantName()));
        htmlLables.add(new HtmlLable(LABLE_P, "每日營業報表"));
        htmlLables.add(new HtmlLable(LABLE_P, "由營業日期:" + mCleanMachineContent.getStartTime()));
        htmlLables.add(new HtmlLable(LABLE_P, "到營業日期:" + mCleanMachineContent.getCurrentTime()));
        htmlLables.add(new HtmlLable(LABLE_P, "-----------------------------------------------------------------"));
        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

    private String getHtmlBusinessTotal() {

        SettlementReport.VoBean voBean = mCleanMachineContent.getVo();
        List<SettlementReport.CashBean> cashs = mCleanMachineContent.getCash();

        List<HtmlLable> htmlLables = new ArrayList<>();

        String[] items = {"項目銷售總額", "折扣", "服務費", "送貨費", "營業今個淨值", "現金核數", "營業金額淨值"};
        List<String> items2 = new ArrayList<>();
        items2.add(String.valueOf(voBean.getPrices()));
        items2.add(String.valueOf(voBean.getDisamount()));
        items2.add(String.valueOf(voBean.getScamount()));
        items2.add(String.valueOf(voBean.getDeliverycharge()));
        items2.add(String.valueOf(voBean.getTotamount()));
        items2.add("");
        items2.add(String.valueOf(voBean.getTotamount()));

        for (int i = 0; i < items.length; i++) {
            htmlLables.add(new HtmlLable(getRowLableStart()));
            htmlLables.add(new HtmlLable(LABLE_COLUMN, items[i]));
            if (items2.size() > (i + 1)) {
                htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(items2.get(i)), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
            }
            htmlLables.add(new HtmlLable(getRowLableEnd()));
        }

        if (cashs != null) {
            for (SettlementReport.CashBean cashBean : cashs) {
                htmlLables.add(new HtmlLable(getRowLableStart()));
                htmlLables.add(new HtmlLable(LABLE_COLUMN, cashBean.getPayName()));
                htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(cashBean.getPayNum()), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_percentage60)));
                htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(cashBean.getPayAmount()), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
                htmlLables.add(new HtmlLable(getRowLableEnd()));
            }
        }
        htmlLables.add(new HtmlLable(LABLE_P, "-----------------------------------------------------------------"));
        htmlLables.add(new HtmlLable(LABLE_P, "-----------------------------------------------------------------"));
        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

    /**
     * 現金詳情
     *
     * @return
     */
    private String getHtmlCashDetails() {
        List<SettlementReport.CashBean> cashs = mCleanMachineContent.getCash();
        if (cashs == null || cashs.size() == 0) {
            return "";
        }
        List<HtmlLable> htmlLables = new ArrayList<>();
        htmlLables.add(new HtmlLable(LABLE_P, "現金詳情", new HtmlLable.Attributes(ATTRIBUTES_ALIGN, value_align_center)));
        for (SettlementReport.CashBean cashBean : cashs) {
            if (cashBean.getPayType() == PayMethod.PAY_TYPE_CASH) {
                htmlLables.add(new HtmlLable(getRowLableStart()));
                htmlLables.add(new HtmlLable(LABLE_COLUMN, cashBean.getPayName()));
                htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(cashBean.getPayNum()), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_percentage60)));
                htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(cashBean.getPayAmount()), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
                htmlLables.add(new HtmlLable(getRowLableEnd()));
                break;
            }
        }
        if (htmlLables.size() > 0) {
            htmlLables.add(new HtmlLable(LABLE_P, "-----------------------------------------------------------------"));
            htmlLables.add(new HtmlLable(LABLE_P, "-----------------------------------------------------------------"));
        }
        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

    /**
     * 分析統計
     *
     * @return
     */
    private String getHtmlAnalysisAndStatistics() {

        SettlementReport.VoBean voBean = mCleanMachineContent.getVo();

        List<HtmlLable> htmlLables = new ArrayList<>();

        htmlLables.add(new HtmlLable(LABLE_P, "分析統計", new HtmlLable.Attributes(ATTRIBUTES_ALIGN, value_align_center)));

        htmlLables.add(new HtmlLable(getRowLableStart()));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, "帳單金額總數"));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(voBean.getTotamount()), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
        htmlLables.add(new HtmlLable(getRowLableEnd()));

        htmlLables.add(new HtmlLable(getRowLableStart()));
        String averagePrice = "0.00";
        if (voBean.getNum() != 0) {
            averagePrice = String.valueOf(MoneyUtil.get_ItemDecimals_money(voBean.getPrices() / voBean.getNum()));
        }
        htmlLables.add(new HtmlLable(LABLE_COLUMN, "帳單數目"));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(voBean.getNum()), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_percentage60)));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, averagePrice, new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
        htmlLables.add(new HtmlLable(getRowLableEnd()));


        htmlLables.add(new HtmlLable(getRowLableStart()));
        String averageConsumption = "0.00";
        if (voBean.getPerson() != 0) {
            averageConsumption = String.valueOf(MoneyUtil.get_ItemDecimals_money(voBean.getPrices() / voBean.getPerson()));
        }
        htmlLables.add(new HtmlLable(LABLE_COLUMN, "人數 / 平均消費"));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, String.valueOf(voBean.getPerson()), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_percentage60)));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, averageConsumption, new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
        htmlLables.add(new HtmlLable(getRowLableEnd()));

        htmlLables.add(new HtmlLable(LABLE_P, "-----------------------------------------------------------------"));
        htmlLables.add(new HtmlLable(LABLE_P, "-----------------------------------------------------------------"));

        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

    /**
     * 賬單統計
     *
     * @return
     */
    private String getHtmlBillingStatisticsItems() {

        List<HtmlLable> htmlLables = new ArrayList<>();
        htmlLables.add(new HtmlLable(LABLE_P, "賬單統計", new HtmlLable.Attributes(ATTRIBUTES_ALIGN, value_align_center)));

        List<SettlementReport.AnalysisBean> analysisBeanList = mCleanMachineContent.getAnalysis();
        SettlementReport.VoBean voBean = mCleanMachineContent.getVo();
        for (int i = 0; i < analysisBeanList.size(); i++) {
            //當前餐廳有幾種訂單：堂食，外賣,自取
            SettlementReport.AnalysisBean analysisBean = analysisBeanList.get(i);
            if (analysisBean.equals("堂食") || analysisBean.equals("外賣") || analysisBean.equals("自取")) {
                htmlLables.addAll(getHtmlBillingStatisticsItem(analysisBean, voBean));
            }
        }
        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

    private List<HtmlLable> getHtmlBillingStatisticsItem(SettlementReport.AnalysisBean analysisBean, SettlementReport.VoBean voBean) {

        String[] items = {"類別", "賬單", "金額", "平均", "金額%"};
        List<String> items2 = new ArrayList<>();

        List<HtmlLable> htmlLables = new ArrayList<>();
        htmlLables.add(new HtmlLable(getRowLableStart()));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, "類別"));
        htmlLables.add(new HtmlLable(LABLE_COLUMN, analysisBean.getTypeName(), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
        htmlLables.add(new HtmlLable(getRowLableEnd()));

        String averagePrice = "";
        String percentage = "";
        double amount = analysisBean.getAmount();
        int num = analysisBean.getNum();
        if (voBean.getNum() != 0) {
            double number = MoneyUtil.divide(amount, num, 2);
            averagePrice = AppConstans.CARSH_STR + MoneyUtil.get_ItemDecimals_money(number);
        }
        if (amount > 0) {
            percentage = AppConstans.CARSH_STR + MoneyUtil.get_ItemDecimals_money((MoneyUtil.divide(amount, voBean.getTotamount(), 2) * 100));
        }
        items2.add(analysisBean.getTypeName());
        items2.add(String.valueOf(analysisBean.getNum()));
        items2.add(String.valueOf(analysisBean.getAmount()));
        items2.add(averagePrice);
        items2.add(percentage);
        for (int i = 0; i < items.length; i++) {
            htmlLables.add(new HtmlLable(getRowLableStart()));
            htmlLables.add(new HtmlLable(LABLE_COLUMN, items[i]));
            if (items2.size() > (i + 1)) {
                htmlLables.add(new HtmlLable(LABLE_COLUMN, items2.get(i), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
            }
            htmlLables.add(new HtmlLable(getRowLableEnd()));
        }
        return htmlLables;
    }


    /**
     * 賬單現況:已完成賬單，未完成賬單,總計...
     *
     * @return
     */
    private String getHtmlBillStatusItems() {

        List<SettlementReport.AnalysisBean> analysisBeanList = mCleanMachineContent.getAnalysis();

        List<String> items = new ArrayList<>();
        List<String> items2 = new ArrayList<>();
        List<String> items3 = new ArrayList<>();
        List<String> items4 = new ArrayList<>();

        items.add("項目");
        items2.add("賬單");
        items3.add("人數");
        items4.add("金額");

        List<HtmlLable> htmlLables = new ArrayList<>();
        htmlLables.add(new HtmlLable(LABLE_P, "賬單現況", new HtmlLable.Attributes(ATTRIBUTES_ALIGN, value_align_center)));

        for (int i = 0; i < analysisBeanList.size(); i++) {
            SettlementReport.AnalysisBean analysisBean = analysisBeanList.get(i);
            if ("已完成賬單".equals(analysisBean.getTypeName()) || "未完成賬單".equals(analysisBean.getTypeName()) || "總計".equals(analysisBean.getTypeName())) {
                items.add(analysisBean.getTypeName());
                items2.add(String.valueOf(analysisBean.getNum()));
                items3.add(String.valueOf(analysisBean.getPerson()));
                items4.add(String.valueOf(analysisBean.getAmount()));
            }
        }

        for (int i = 0; i < items.size(); i++) {
            htmlLables.add(new HtmlLable(getRowLableStart()));
            htmlLables.add(new HtmlLable(LABLE_COLUMN, items.get(i)));
            if (items2.size() > (i + 1)) {
                htmlLables.add(new HtmlLable(LABLE_COLUMN, items2.get(i), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_percentage30)));
            }
            if (items3.size() > (i + 1)) {
                htmlLables.add(new HtmlLable(LABLE_COLUMN, items3.get(i), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_percentage60)));
            }
            if (items4.size() > (i + 1)) {
                htmlLables.add(new HtmlLable(LABLE_COLUMN, items4.get(i), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
            }
            htmlLables.add(new HtmlLable(getRowLableEnd()));
        }

        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }


    private String getHtmlCumulativeThisMonth() {

        List<HtmlLable> htmlLables = new ArrayList<>();

        SettlementReport.AnalysisBean analysisBean = mAnalysisBeanMap.get("本月累計營業額");

        String firstDayOfMonth = TimeUtils.getFirstDayOfMonth(TimeUtils.DATE_FORMAT_DATE) + " 00:00:00";
        String currentDate = TimeUtils.getCurrentDate(TimeUtils.DEFAULT_DATE_FORMAT);

        List<String> items = new ArrayList<>();
        items.add("本月累計營業額");
        items.add("由營業日期:" + firstDayOfMonth);
        items.add("到營業日期:" + currentDate);
        items.add("營業金額淨值");

        List<String> items2 = new ArrayList<>();
        items2.add("");
        items2.add("");
        items2.add("");
        if (analysisBean != null) {
            items2.add(AppConstans.CARSH_STR + analysisBean.getAmount());
        } else {
            items2.add(AppConstans.CARSH_STR + "0.00");
        }

        for (int i = 0; i < items.size(); i++) {
            htmlLables.add(new HtmlLable(getRowLableStart()));
            htmlLables.add(new HtmlLable(LABLE_COLUMN, items.get(i)));
            if (items2.size() > (i + 1)) {
                htmlLables.add(new HtmlLable(LABLE_COLUMN, items2.get(i), new HtmlLable.Attributes(ATTRIBUTES_OFFSET, value_offset_last)));
            }
            htmlLables.add(new HtmlLable(getRowLableEnd()));
        }

        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }


    private String getHtmlEndInfo() {

        List<HtmlLable> htmlLables = new ArrayList<>();

        String currentDate = TimeUtils.getCurrentDate(TimeUtils.DEFAULT_DATE_FORMAT);

        List<String> items = new ArrayList<>();
        items.add("報表完結");
        items.add("讀取人員:" + UserContext.newInstance().getMemberName());
        items.add(currentDate);
        for (int i = 0; i < items.size(); i++) {
            htmlLables.add(new HtmlLable(getRowLableStart()));
            htmlLables.add(new HtmlLable(LABLE_COLUMN, items.get(i)));
            htmlLables.add(new HtmlLable(getRowLableEnd()));
        }
        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

}
