package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2020/1/17.
 */
public interface OrderPayService {

    @POST("order/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateOrder(@Body RequestBody requestBody);

    @POST("orderPay/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateOrderPay(@Body RequestBody requestBody);

    @POST("orderPay/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> toOrderPay(@Body RequestBody requestBody);

    @GET("restaurant/pay/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getPayMethods(@Query("brandId") int brandId,@Query("restaurantId") int restaurantId,@Query("payType") int payType);
}
