package com.gingersoft.gsa.cloud.base.adapter.print;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/9.
 */
public class BillAdapter extends BaseQuickAdapter<BillingBean, BaseViewHolder> {

    public BillAdapter(@Nullable List<BillingBean> data) {
        super(R.layout.print_item_bill, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, BillingBean item) {
        helper.setText(R.id.tv_total_text, item.getOptionName());
        if (item.getTotalAmount() < 0) {
            helper.setText(R.id.tv_total, "-$" + Math.abs(item.getTotalAmount()));
        } else if(item.getTotalAmount() > 0){
            helper.setText(R.id.tv_total, "$" + item.getTotalAmount());
        }
    }
}
