package com.gingersoft.gsa.cloud.base.application;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.RemoteException;
import com.billy.cc.core.component.CC;
import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.LogLevel;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.interceptor.BlacklistTagsFilterInterceptor;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.ConsolePrinter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.FilePrinter;
import com.elvishew.xlog.printer.file.clean.FileLastModifiedCleanStrategy;
import com.elvishew.xlog.printer.file.naming.DateFileNameGenerator;
import com.gingersoft.gsa.cloud.base.BuildConfig;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.function.FunctionStyleUtils;
import com.gingersoft.gsa.cloud.base.utils.AidlUtil;
import com.gingersoft.gsa.cloud.constans.Constans;
import com.gingersoft.gsa.cloud.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.constans.UserConstans;
import com.gingersoft.gsa.cloud.base.utils.crash.AppCrashHandler;
import com.gingersoft.gsa.cloud.base.utils.file.FileUtils;
import com.gingersoft.gsa.cloud.base.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.base.utils.xlog.MyBackupStrategy;
import com.gingersoft.gsa.cloud.database.DaoManager;
import com.hyweb.n5.lib.exception.NoInitPrinterException;
import com.hyweb.n5.lib.util.PrinterUtil;
import com.jess.arms.base.BaseApplication;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.DefaultRefreshFooterCreator;
import com.scwang.smartrefresh.layout.api.DefaultRefreshHeaderCreator;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import java.util.Locale;
import com.gingersoft.gsa.cloud.base.qmui.manager.QDSkinManager;
import androidx.annotation.NonNull;
import me.jessyan.autosize.AutoSize;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.onAdaptListener;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;

/**
 * Created by Wyh on 2019/12/21.
 */
public class GsaCloudApplication extends BaseApplication {

    /**
     * 系统上下文
     */
    private static GsaCloudApplication mAppContext;
    private Activity mCurrentActivity;

    /**是否開啟皮膚切換*/
    public static boolean openSkinMake = false;
    /**
     * 设置请求超时默认15秒钟
     */
    public static int REQUEST_TIMEOUT = 15;

    public static boolean isLogin = false;
    public static FunctionStyleUtils androidSetting;
    public static String userName = "";
    /**
     * 商米:V2、V2_PRO   N5:N5
     */
    public static String mV2 = "V2,V2_PRO";
    public static String mN5 = "N5";

    /**
     * 全局設置上下拉刷新框架Header 和 Footer
     */
    static {
        //设置全局的Header构建器
        SmartRefreshLayout.setDefaultRefreshHeaderCreator(new DefaultRefreshHeaderCreator() {
            @Override
            public RefreshHeader createRefreshHeader(Context context, RefreshLayout layout) {
                layout.setPrimaryColorsId(R.color.theme_color, android.R.color.white);//全局设置主题颜色
                return new ClassicsHeader(context);//.setTimeFormat(new DynamicTimeFormat("更新于 %s"));//指定为经典Header，默认是 贝塞尔雷达Header
            }
        });
        //设置全局的Footer构建器
        SmartRefreshLayout.setDefaultRefreshFooterCreator(new DefaultRefreshFooterCreator() {
            @Override
            public RefreshFooter createRefreshFooter(Context context, RefreshLayout layout) {
                //指定为经典Footer，默认是 BallPulseFooter
                return new ClassicsFooter(context).setDrawableSize(20);
            }
        });
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.mAppContext = this;
        CC.enableVerboseLog(true);
        CC.enableDebug(true);
        CC.enableRemoteCC(true);

        QDSkinManager.install(this);
        //初始化上下拉刷新
        initRefresh();
        //初始化今日頭條適配方案
        initAutoSize();
        //初始化數據庫框架
        initGreenDao();
        //初始化打印相關
        initPrint();
        //初始化日誌管理庫
        initXLog();
        initDomainUrl();
        //初始化crash記錄
        AppCrashHandler.getInstance().init(this);

        androidSetting = new FunctionStyleUtils();
    }

    public Activity getCurrentActivity() {
        return mCurrentActivity;
    }

    public void setCurrentActivity(Activity mCurrentActivity) {
        this.mCurrentActivity = mCurrentActivity;
    }

    private void initRefresh() {
        ClassicsHeader.REFRESH_HEADER_PULLING = getString(R.string.srl_header_pulling);//"下拉可以刷新";
        ClassicsHeader.REFRESH_HEADER_REFRESHING = getString(R.string.srl_header_refreshing);//"正在刷新...";
        ClassicsHeader.REFRESH_HEADER_LOADING = getString(R.string.srl_header_loading);//"正在加载...";
        ClassicsHeader.REFRESH_HEADER_RELEASE = getString(R.string.srl_header_release);//"释放立即刷新";
        ClassicsHeader.REFRESH_HEADER_FINISH = getString(R.string.srl_header_finish);//"刷新完成";
        ClassicsHeader.REFRESH_HEADER_FAILED = getString(R.string.srl_header_failed);//"刷新失败";
        ClassicsHeader.REFRESH_HEADER_UPDATE = getString(R.string.srl_header_update);//"上次更新 M-d HH:mm";
        ClassicsHeader.REFRESH_HEADER_UPDATE = getString(R.string.srl_header_update);//"'Last update' M-d HH:mm";
        ClassicsHeader.REFRESH_HEADER_SECONDARY = getString(R.string.srl_header_secondary);//"释放进入二楼"

        ClassicsFooter.REFRESH_FOOTER_PULLING = getString(R.string.srl_footer_pulling);//"上拉加载更多";
        ClassicsFooter.REFRESH_FOOTER_RELEASE = getString(R.string.srl_footer_release);//"释放立即加载";
        ClassicsFooter.REFRESH_FOOTER_LOADING = getString(R.string.srl_footer_loading);//"正在刷新...";
        ClassicsFooter.REFRESH_FOOTER_REFRESHING = getString(R.string.srl_footer_refreshing);//"正在加载...";
        ClassicsFooter.REFRESH_FOOTER_FINISH = getString(R.string.srl_footer_finish);//"加载完成";
        ClassicsFooter.REFRESH_FOOTER_FAILED = getString(R.string.srl_footer_failed);//"加载失败";
        ClassicsFooter.REFRESH_FOOTER_NOTHING = getString(R.string.srl_footer_nothing);//"全部加载完成";
    }

    private void initDomainUrl() {
        //需要單獨配置域名URL的，在接口上添加@Headers({"Domain-Name: settlement_report_server"})，不添加則是使用默認域名
        setGlobalDomain();
        //清機報表請求地址
        RetrofitUrlManager.getInstance().putDomain("settlement_report_server", HttpsConstans.ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL);
        //gsa報表請求地址
        RetrofitUrlManager.getInstance().putDomain("gsa_report", HttpsConstans.REPORT_SERVER_ADDRESS);
        //微信報表請求地址
        RetrofitUrlManager.getInstance().putDomain("wechat_report", HttpsConstans.WECHAR_REPORT_SERVER_ADDRESS);
        //沽清控制請求地址
        RetrofitUrlManager.getInstance().putDomain("soldoutctrl", HttpsConstans._SERVER_ADDRESS);
    }

    private void initPrint() {
        if (GsaCloudApplication.mV2.contains(Build.MODEL)) {
            //商米打印
            AidlUtil.getInstance().connectPrinterService(this);
        } else if (GsaCloudApplication.mN5.contains(Build.MODEL)) {
            try {
                //初始化N5打印
                PrinterUtil.initPrinter(this);
            } catch (NoInitPrinterException | RemoteException e) {
                e.printStackTrace();
            }
        } else {
            //如果當前機型不是上面兩種，那麼設置默認打印為ip打印
            SPUtils.put(this, Constans.DEFAULT_PRINT_METHOD, Constans.IP_PRINT);
        }
    }

    public static void setGlobalDomain() {
        //配置全局默認URL
        RetrofitUrlManager.getInstance().setGlobalDomain(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL);
    }

    private void initXLog() {
        LogConfiguration config = new LogConfiguration.Builder()
                .logLevel(BuildConfig.DEBUG ? LogLevel.ALL             // 指定日志级别，低于该级别的日志将不会被打印，默认为 LogLevel.ALL
                        : LogLevel.NONE)
                .tag("GSA_Cloud_TAG")                                         // 指定 TAG，默认为 "X-LOG"
                .addInterceptor(new BlacklistTagsFilterInterceptor(    // 添加黑名单 TAG 过滤器
                        "blacklist1", "blacklist2", "blacklist3"))
                .build();

        Printer androidPrinter = new AndroidPrinter();             // 通过 android.util.Log 打印日志的打印器
        Printer consolePrinter = new ConsolePrinter();             // 通过 System.out 打印日志到控制台的打印器
        Printer filePrinter = new FilePrinter                      // 打印日志到文件的打印器
                .Builder(FileUtils.ACTIONLOG_PATH)                              // 指定保存日志文件的路径
                .fileNameGenerator(new DateFileNameGenerator())        // 指定日志文件名生成器，默认为 ChangelessFileNameGenerator("log")
                .backupStrategy(new MyBackupStrategy(FileUtils.ACTION_MAX_SIZE))         // 指定日志文件备份策略，默认为 FileSizeBackupStrategy(1024 * 1024)
                .cleanStrategy(new FileLastModifiedCleanStrategy(FileUtils.ACTION_MAX_FILE_TIME))     // 指定日志文件清除策略，默认为 NeverCleanStrategy()
                .build();

        XLog.init(                                                 // 初始化 XLog
                config,                                                // 指定日志配置，如果不指定，会默认使用 new LogConfiguration.Builder().build()
                androidPrinter,                                        // 添加任意多的打印器。如果没有添加任何打印器，会默认使用 AndroidPrinter(Android)/ConsolePrinter(java)
                consolePrinter,
                filePrinter);
    }


    private void initAutoSize(){
        //当 App 中出现多进程, 并且您需要适配所有的进程, 就需要在 App 初始化时调用 initCompatMultiProcess()
        //在 Demo 中跳转的三方库中的 DefaultErrorActivity 就是在另外一个进程中, 所以要想适配这个 Activity 就需要调用 initCompatMultiProcess()
        AutoSize.initCompatMultiProcess(this);

        //如果在某些特殊情况下出现 InitProvider 未能正常实例化, 导致 AndroidAutoSize 未能完成初始化
        //可以主动调用 AutoSize.checkAndInit(this) 方法, 完成 AndroidAutoSize 的初始化后即可正常使用
//        AutoSize.checkAndInit(this);

//        如何控制 AndroidAutoSize 的初始化，让 AndroidAutoSize 在某些设备上不自动启动？https://github.com/JessYanCoding/AndroidAutoSize/issues/249

        /**
         * 以下是 AndroidAutoSize 可以自定义的参数, {@link AutoSizeConfig} 的每个方法的注释都写的很详细
         * 使用前请一定记得跳进源码，查看方法的注释, 下面的注释只是简单描述!!!
         */
        AutoSizeConfig.getInstance()

                //是否让框架支持自定义 Fragment 的适配参数, 由于这个需求是比较少见的, 所以须要使用者手动开启
                //如果没有这个需求建议不开启
                .setCustomFragment(true)

                //是否屏蔽系统字体大小对 AndroidAutoSize 的影响, 如果为 true, App 内的字体的大小将不会跟随系统设置中字体大小的改变
                //如果为 false, 则会跟随系统设置中字体大小的改变, 默认为 false
//                .setExcludeFontScale(true)

                //区别于系统字体大小的放大比例, AndroidAutoSize 允许 APP 内部可以独立于系统字体大小之外，独自拥有全局调节 APP 字体大小的能力
                //当然, 在 APP 内您必须使用 sp 来作为字体的单位, 否则此功能无效, 不设置或将此值设为 0 则取消此功能
//                .setPrivateFontScale(0.8f)

                //屏幕适配监听器
                .setOnAdaptListener(new onAdaptListener() {
                    @Override
                    public void onAdaptBefore(Object target, Activity activity) {
                        //使用以下代码, 可以解决横竖屏切换时的屏幕适配问题
                        //使用以下代码, 可支持 Android 的分屏或缩放模式, 但前提是在分屏或缩放模式下当用户改变您 App 的窗口大小时
                        //系统会重绘当前的页面, 经测试在某些机型, 某些情况下系统不会重绘当前页面, ScreenUtils.getScreenSize(activity) 的参数一定要不要传 Application!!!
//                        AutoSizeConfig.getInstance().setScreenWidth(ScreenUtils.getScreenSize(activity)[0]);
//                        AutoSizeConfig.getInstance().setScreenHeight(ScreenUtils.getScreenSize(activity)[1]);
                        LogUtil.d(String.format(Locale.ENGLISH, "%s onAdaptBefore!", target.getClass().getName()));
                    }

                    @Override
                    public void onAdaptAfter(Object target, Activity activity) {
                        LogUtil.d(String.format(Locale.ENGLISH, "%s onAdaptAfter!", target.getClass().getName()));
                    }
                });

        //是否打印 AutoSize 的内部日志, 默认为 true, 如果您不想 AutoSize 打印日志, 则请设置为 false
//                .setLog(false)

        //是否使用设备的实际尺寸做适配, 默认为 false, 如果设置为 false, 在以屏幕高度为基准进行适配时
        //AutoSize 会将屏幕总高度减去状态栏高度来做适配
        //设置为 true 则使用设备的实际屏幕高度, 不会减去状态栏高度
        //在全面屏或刘海屏幕设备中, 获取到的屏幕高度可能不包含状态栏高度, 所以在全面屏设备中不需要减去状态栏高度，所以可以 setUseDeviceSize(true)
//                .setUseDeviceSize(true)

        //是否全局按照宽度进行等比例适配, 默认为 true, 如果设置为 false, AutoSize 会全局按照高度进行适配
//                .setBaseOnWidth(false)

        //设置屏幕适配逻辑策略类, 一般不用设置, 使用框架默认的就好
//                .setAutoAdaptStrategy(new AutoAdaptStrategy())
        customAdaptForExternal();
    }

    /**
     * 给外部的三方库 {@link Activity} 自定义适配参数, 因为三方库的 {@link Activity} 并不能通过实现
     * {@link CustomAdapt} 接口的方式来提供自定义适配参数 (因为远程依赖改不了源码)
     * 所以使用 {@link ExternalAdaptManager} 来替代实现接口的方式, 来提供自定义适配参数
     */
    private void customAdaptForExternal() {
        /**
         * {@link ExternalAdaptManager} 是一个管理外部三方库的适配信息和状态的管理类, 详细介绍请看 {@link ExternalAdaptManager} 的类注释
         */
        AutoSizeConfig.getInstance().getExternalAdaptManager();

        //加入的 Activity 将会放弃屏幕适配, 一般用于三方库的 Activity, 详情请看方法注释
        //如果不想放弃三方库页面的适配, 请用 addExternalAdaptInfoOfActivity 方法, 建议对三方库页面进行适配, 让自己的 App 更完美一点
//                .addCancelAdaptOfActivity(DefaultErrorActivity.class)

        //为指定的 Activity 提供自定义适配参数, AndroidAutoSize 将会按照提供的适配参数进行适配, 详情请看方法注释
        //一般用于三方库的 Activity, 因为三方库的设计图尺寸可能和项目自身的设计图尺寸不一致, 所以要想完美适配三方库的页面
        //就需要提供三方库的设计图尺寸, 以及适配的方向 (以宽为基准还是高为基准?)
        //三方库页面的设计图尺寸可能无法获知, 所以如果想让三方库的适配效果达到最好, 只有靠不断的尝试
        //由于 AndroidAutoSize 可以让布局在所有设备上都等比例缩放, 所以只要您在一个设备上测试出了一个最完美的设计图尺寸
        //那这个三方库页面在其他设备上也会呈现出同样的适配效果, 等比例缩放, 所以也就完成了三方库页面的屏幕适配
        //即使在不改三方库源码的情况下也可以完美适配三方库的页面, 这就是 AndroidAutoSize 的优势
        //但前提是三方库页面的布局使用的是 dp 和 sp, 如果布局全部使用的 px, 那 AndroidAutoSize 也将无能为力
        //经过测试 DefaultErrorActivity 的设计图宽度在 380dp - 400dp 显示效果都是比较舒服的
//                .addExternalAdaptInfoOfActivity(DefaultErrorActivity.class, new ExternalAdaptInfo(true, 400));
    }

    private void initGreenDao() {
        DaoManager manager = DaoManager.getInstance();
        manager.init(this);
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if((newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK) == Configuration.UI_MODE_NIGHT_YES){
            QDSkinManager.changeSkin(QDSkinManager.SKIN_DARK);
        }else if(QDSkinManager.getCurrentSkin() == QDSkinManager.SKIN_DARK){
            QDSkinManager.changeSkin(QDSkinManager.SKIN_BLUE);
        }
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
    }

    /**
     * 获取系统上下文：用于ToastUtil类
     */
    public static GsaCloudApplication getAppContext() {
        return mAppContext;
    }


    //获取登陆token
    public static String getLoginToken(Context context) {
        return (String) SPUtils.get(context, UserConstans.token, "");
    }

    public static int getMemberId(Context context) {
        return (int) SPUtils.get(context, UserConstans.memberId, 0);
    }

    public static int getBrandId(Context context) {
        return (int) SPUtils.get(context, UserConstans.brandId, 0);
    }

    public static String getBrandName(Context context) {
        return (String) SPUtils.get(context, UserConstans.brandName, "");
    }

    public static int getRestaurantId(Context context) {
        return (int) SPUtils.get(context, UserConstans.restaurantId, 0);
    }

    public static String getRestaurantName(Context context) {
        return (String) SPUtils.get(context, UserConstans.restaurantName, "");
    }

    public static String getMemberName(Context context) {
        return (String) SPUtils.get(context, UserConstans.memberName, "");
    }

    public static String getBrandRestaurantInfos(Context context) {
        return (String) SPUtils.get(context, UserConstans.brandRestaurantInfos, "");
    }

    public static void setLoginToken(Context context, String token) {
        SPUtils.put(context, UserConstans.token, token);
    }

    public static void setMemberId(Context context, int memberId) {
        SPUtils.put(context, UserConstans.memberId, memberId);
    }

    public static void setMemberName(Context context, String memberName) {
        SPUtils.put(context, UserConstans.memberName, memberName);
    }

    public static void setBrandId(Context context, int restaurantId) {
        SPUtils.put(context, UserConstans.brandId, restaurantId);
    }

    public static void setBrandName(Context context, String restaurantName) {
        SPUtils.put(context, UserConstans.brandName, restaurantName);
    }

    public static void setRestaurantId(Context context, int restaurantId) {
        SPUtils.put(context, UserConstans.restaurantId, restaurantId);
    }

    public static void setRestaurantName(Context context, String restaurantName) {
        SPUtils.put(context, UserConstans.restaurantName, restaurantName);
    }

    public static void setBrandRestaurantInfos(Context context, String brandRestaurantIds) {
        SPUtils.put(context, UserConstans.brandRestaurantInfos, brandRestaurantIds);
    }

    public static void clearMemberInfo() {
        setLoginToken(mAppContext, "");
        setMemberId(mAppContext, 0);
        setMemberName(mAppContext, "");
        setBrandId(mAppContext, 0);
        setBrandName(mAppContext, "");
        setRestaurantId(mAppContext, 0);
        setRestaurantName(mAppContext, "");
        setBrandRestaurantInfos(mAppContext, "");
    }

}
